/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.components.BuddyListFrame;
import org.walluck.oscar.components.Dialogs;
import org.walluck.oscar.components.IMWindow;
import org.walluck.oscar.components.Main;
import org.walluck.oscar.components.SessionManager;

public class IMActions {
    private static IMActionsListener listener;
    private static List top;
    private static List normal;
    private static List bottom;

    private IMActions() {
    }

    public static void addFirstAction(IMAction act) {
        top.add(act);
        if (listener != null) {
            listener.imActionsChanged();
        }
    }

    public static void addLastAction(IMAction act) {
        bottom.add(act);
        if (listener != null) {
            listener.imActionsChanged();
        }
    }

    public static void addNormalAction(IMAction act) {
        normal.add(act);
        if (listener != null) {
            listener.imActionsChanged();
        }
    }

    public static Iterator getFirstActions() {
        return top.iterator();
    }

    public static Iterator getNormalActions() {
        return normal.iterator();
    }

    public static Iterator getLastActions() {
        return bottom.iterator();
    }

    public static void setIMActionsListener(IMActionsListener lis) {
        listener = lis;
    }

    static {
        top = new ArrayList();
        normal = new ArrayList();
        bottom = new ArrayList();
        IMActions.addFirstAction(new ActionInfo());
        IMActions.addFirstAction(new ActionIM());
        IMActions.addLastAction(new ActionRemove());
    }

    private static class ActionInfo
    extends AbstractAction
    implements IMAction {
        public ActionInfo() {
            super("Get Info");
        }

        public boolean isActionEnabledForBuddy(Buddy b) {
            return b.getProperty(Buddy.STATE) != null;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                String name = BuddyListFrame.getBuddyListFrame().getBuddyList().getSelectedBuddy().getName();
                Main.OSCAR.getInfo(SessionManager.getSessions()[0], name);
                Main.OSCAR.getAway(SessionManager.getSessions()[0], name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class ActionRemove
    extends AbstractAction
    implements IMAction {
        public ActionRemove() {
            super("Remove");
        }

        public boolean isActionEnabledForBuddy(Buddy b) {
            return true;
        }

        public void actionPerformed(ActionEvent evt) {
            Dialogs.showRemoveBuddyDialog(BuddyListFrame.getBuddyListFrame().getBuddyList().getSelectedBuddy().getName());
        }
    }

    private static class ActionIM
    extends AbstractAction
    implements IMAction {
        public ActionIM() {
            super("IM");
        }

        public boolean isActionEnabledForBuddy(Buddy b) {
            return b.getProperty(Buddy.STATE) != null;
        }

        public void actionPerformed(ActionEvent evt) {
            Buddy b = BuddyListFrame.getBuddyListFrame().getBuddyList().getSelectedBuddy();
            AIMSession sess = (AIMSession)b.getProperty(Buddy.SESSION);
            IMWindow.createIMWindow(sess, b);
        }
    }

    public static interface IMActionsListener {
        public void imActionsChanged();
    }

    public static interface IMAction
    extends Action {
        public boolean isActionEnabledForBuddy(Buddy var1);

        public void setEnabled(boolean var1);
    }
}

