/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.security.SecureRandom;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.User;
import com.liferay.portal.security.pwd.BasicToolkit;
import com.liferay.portal.service.PasswordTrackerLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.words.WordsUtil;
import com.liferay.util.PwdGenerator;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class PasswordPolicyToolkit
extends BasicToolkit {
    private char[] _alphanumericCharsetArray;
    private String _completeCharset;
    private char[] _lowerCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_LOWERCASE);
    private char[] _numbersCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_NUMBERS);
    private char[] _symbolsCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_SYMBOLS);
    private char[] _upperCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_UPPERCASE);

    public PasswordPolicyToolkit() {
        this._alphanumericCharsetArray = ArrayUtil.append((char[][])new char[][]{this._lowerCaseCharsetArray, this._upperCaseCharsetArray, this._numbersCharsetArray});
        Arrays.sort(this._alphanumericCharsetArray);
        StringBundler sb = new StringBundler(4);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_LOWERCASE);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_NUMBERS);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_SYMBOLS);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_UPPERCASE);
        this._completeCharset = sb.toString();
    }

    public String generate(PasswordPolicy passwordPolicy) {
        if (PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR.equals("static")) {
            return this.generateStatic(passwordPolicy);
        }
        return this.generateDynamic(passwordPolicy);
    }

    public void validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        long minAge;
        Date now;
        long passwordModificationElapsedTime;
        if (passwordPolicy.isCheckSyntax()) {
            if (!passwordPolicy.isAllowDictionaryWords() && WordsUtil.isDictionaryWord(password1)) {
                throw new UserPasswordException(2);
            }
            if (password1.length() < passwordPolicy.getMinLength()) {
                throw new UserPasswordException(4);
            }
            if (this.getUsageCount(password1, this._alphanumericCharsetArray) < passwordPolicy.getMinAlphanumeric() || this.getUsageCount(password1, this._lowerCaseCharsetArray) < passwordPolicy.getMinLowerCase() || this.getUsageCount(password1, this._numbersCharsetArray) < passwordPolicy.getMinNumbers() || this.getUsageCount(password1, this._symbolsCharsetArray) < passwordPolicy.getMinSymbols() || this.getUsageCount(password1, this._upperCaseCharsetArray) < passwordPolicy.getMinUpperCase()) {
                throw new UserPasswordException(8);
            }
            if (Validator.isNotNull((String)passwordPolicy.getRegex()) && !password1.matches(passwordPolicy.getRegex())) {
                throw new UserPasswordException(3);
            }
        }
        if (!passwordPolicy.isChangeable() && userId != 0L) {
            throw new UserPasswordException(5);
        }
        if (userId == 0L) {
            return;
        }
        User user = UserLocalServiceUtil.getUserById((long)userId);
        Date passwordModfiedDate = user.getPasswordModifiedDate();
        if (passwordModfiedDate != null && (passwordModificationElapsedTime = (now = new Date()).getTime() - passwordModfiedDate.getTime()) < (minAge = passwordPolicy.getMinAge() * 1000L) && !user.getPasswordReset()) {
            throw new UserPasswordException(9);
        }
        if (PasswordTrackerLocalServiceUtil.isSameAsCurrentPassword((long)userId, (String)password1)) {
            throw new UserPasswordException(6);
        }
        if (!PasswordTrackerLocalServiceUtil.isValidPassword((long)userId, (String)password1)) {
            throw new UserPasswordException(1);
        }
    }

    protected String generateDynamic(PasswordPolicy passwordPolicy) {
        int count;
        int alphanumericActualMinLength = passwordPolicy.getMinLowerCase() + passwordPolicy.getMinNumbers() + passwordPolicy.getMinUpperCase();
        int alphanumericMinLength = Math.max(passwordPolicy.getMinAlphanumeric(), alphanumericActualMinLength);
        int passwordMinLength = Math.max(passwordPolicy.getMinLength(), alphanumericMinLength + passwordPolicy.getMinSymbols());
        StringBundler sb = new StringBundler(6);
        if (passwordPolicy.getMinLowerCase() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinLowerCase(), this._lowerCaseCharsetArray));
        }
        if (passwordPolicy.getMinNumbers() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinNumbers(), this._numbersCharsetArray));
        }
        if (passwordPolicy.getMinSymbols() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinSymbols(), this._symbolsCharsetArray));
        }
        if (passwordPolicy.getMinUpperCase() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinUpperCase(), this._upperCaseCharsetArray));
        }
        if (alphanumericMinLength > alphanumericActualMinLength) {
            count = alphanumericMinLength - alphanumericActualMinLength;
            sb.append(this.getRandomString(count, this._alphanumericCharsetArray));
        }
        if (passwordMinLength > alphanumericMinLength + passwordPolicy.getMinSymbols()) {
            count = passwordMinLength - (alphanumericMinLength + passwordPolicy.getMinSymbols());
            sb.append(PwdGenerator.getPassword((String)this._completeCharset, (int)count));
        }
        if (sb.index() == 0) {
            sb.append(PwdGenerator.getPassword((String)this._completeCharset, (int)PropsValues.PASSWORDS_DEFAULT_POLICY_MIN_LENGTH));
        }
        return RandomUtil.shuffle((Random)new SecureRandom(), (String)sb.toString());
    }

    protected String generateStatic(PasswordPolicy passwordPolicy) {
        return PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_STATIC;
    }

    protected String getRandomString(int count, char[] chars) {
        SecureRandom random = new SecureRandom();
        StringBundler sb = new StringBundler(count);
        int i2 = 0;
        while (i2 < count) {
            int index = random.nextInt(chars.length);
            sb.append(chars[index]);
            ++i2;
        }
        return sb.toString();
    }

    protected char[] getSortedCharArray(String s) {
        char[] chars = s.toCharArray();
        Arrays.sort(chars);
        return chars;
    }

    protected int getUsageCount(String s, char[] chars) {
        int count = 0;
        int i2 = 0;
        while (i2 < s.length()) {
            if (Arrays.binarySearch(chars, s.charAt(i2)) >= 0) {
                ++count;
            }
            ++i2;
        }
        return count;
    }
}

