/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.impl.BaseCommandReceiver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Group;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttachmentCommandReceiver
extends BaseCommandReceiver {
    @Override
    protected String createFolder(CommandArgument commandArgument) {
        return "0";
    }

    @Override
    protected String fileUpload(CommandArgument commandArgument, String fileName, InputStream inputStream, String extension, long size) {
        try {
            HttpServletRequest request = commandArgument.getHttpServletRequest();
            long resourcePK = ParamUtil.getLong((HttpServletRequest)request, (String)"wikiPageResourcePrimKey");
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)resourcePK);
            String title = page.getTitle();
            long nodeId = page.getNodeId();
            ArrayList<ObjectValuePair> inputStreamOVPs = new ArrayList<ObjectValuePair>(1);
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
            inputStreamOVPs.add(inputStreamOVP);
            WikiPageServiceUtil.addPageAttachments((long)nodeId, (String)title, inputStreamOVPs);
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
        return "0";
    }

    @Override
    protected void getFolders(CommandArgument commandArgument, Document document, Node rootNode) {
    }

    @Override
    protected void getFoldersAndFiles(CommandArgument commandArgument, Document document, Node rootNode) {
        try {
            this._getFiles(commandArgument, document, rootNode);
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
    }

    @Override
    protected boolean isStagedData(Group group) {
        return group.isStagedPortlet("36");
    }

    private void _getFiles(CommandArgument commandArgument, Document document, Node rootNode) throws Exception {
        Element filesElement = document.createElement("Files");
        rootNode.appendChild(filesElement);
        HttpServletRequest request = commandArgument.getHttpServletRequest();
        long wikiPageResourcePrimKey = ParamUtil.getLong((HttpServletRequest)request, (String)"wikiPageResourcePrimKey");
        WikiPage wikiPage = WikiPageLocalServiceUtil.getPage((long)wikiPageResourcePrimKey);
        String attachmentURLPrefix = ParamUtil.getString((HttpServletRequest)request, (String)"attachmentURLPrefix");
        for (FileEntry fileEntry : wikiPage.getAttachmentsFileEntries()) {
            Element fileElement = document.createElement("File");
            filesElement.appendChild(fileElement);
            fileElement.setAttribute("name", fileEntry.getTitle());
            fileElement.setAttribute("desc", fileEntry.getTitle());
            fileElement.setAttribute("size", String.valueOf(fileEntry.getSize()));
            fileElement.setAttribute("url", String.valueOf(attachmentURLPrefix) + fileEntry.getTitle());
        }
    }
}

