/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class TypeConverterMetadata
extends AbstractConverterMetadata {
    private MetadataClass m_dataType;
    private MetadataClass m_objectType;
    private String m_dataTypeName;
    private String m_objectTypeName;

    public TypeConverterMetadata() {
        super("<type-converter>");
    }

    public TypeConverterMetadata(String xmlElement) {
        super(xmlElement);
    }

    public TypeConverterMetadata(MetadataAnnotation typeConverter, MetadataAccessibleObject accessibleObject) {
        super(typeConverter, accessibleObject);
        this.m_dataType = this.getMetadataClass((String)typeConverter.getAttributeString("dataType"));
        this.m_objectType = this.getMetadataClass((String)typeConverter.getAttributeString("objectType"));
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TypeConverterMetadata) {
            TypeConverterMetadata typeConverter = (TypeConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.getName(), typeConverter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_dataType, typeConverter.getDataType())) {
                return false;
            }
            return this.valuesMatch(this.m_objectType, typeConverter.getObjectType());
        }
        return false;
    }

    public MetadataClass getDataType() {
        return this.m_dataType;
    }

    public MetadataClass getDataType(MappingAccessor accessor, MetadataClass referenceClass) {
        if (this.m_dataType.isVoid()) {
            if (referenceClass == null) {
                throw ValidationException.noConverterDataTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName(), this.getName());
            }
            accessor.getLogger().logConfigMessage("metadata_default_converter_data_type", accessor, (Object)this.getName(), (Object)referenceClass);
            return referenceClass;
        }
        return this.m_dataType;
    }

    public String getDataTypeName() {
        return this.m_dataTypeName;
    }

    public MetadataClass getObjectType(MappingAccessor accessor, MetadataClass referenceClass) {
        if (this.m_objectType.isVoid()) {
            if (referenceClass == null) {
                throw ValidationException.noConverterObjectTypeSpecified(accessor.getJavaClass(), accessor.getAttributeName(), this.getName());
            }
            accessor.getLogger().logConfigMessage("metadata_default_converter_object_type", accessor, (Object)this.getName(), (Object)referenceClass);
            return referenceClass;
        }
        return this.m_objectType;
    }

    public MetadataClass getObjectType() {
        return this.m_objectType;
    }

    public String getObjectTypeName() {
        return this.m_objectTypeName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_dataType = this.initXMLClassName(this.m_dataTypeName);
        this.m_objectType = this.initXMLClassName(this.m_objectTypeName);
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        TypeConversionConverter converter = new TypeConversionConverter(mapping);
        converter.setDataClassName(this.getDataType(accessor, referenceClass).getName());
        converter.setObjectClassName(this.getObjectType(accessor, referenceClass).getName());
        this.setConverter(mapping, converter, isForMapKey);
        this.setFieldClassification(mapping, this.getJavaClass(this.m_dataType), isForMapKey);
    }

    public void setDataType(MetadataClass dataType) {
        this.m_dataType = dataType;
    }

    public void setDataTypeName(String dataTypeName) {
        this.m_dataTypeName = dataTypeName;
    }

    public void setObjectType(MetadataClass objectType) {
        this.m_objectType = objectType;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.m_objectTypeName = objectTypeName;
    }
}

