/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.File;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.util.Temps;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tools.tar.TarOutputStream;

public class TarOutputArchive
extends TarOutputStream
implements OutputArchive {
    private static final String TEMP_FILE_PREFIX = "tzp-tar";
    private final Map entries = new LinkedHashMap();
    private OutputArchiveMetaData metaData;
    private boolean busy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TarOutputArchive(OutputStream out) {
        super(out);
        super.setLongFileMode(2);
    }

    public int getNumArchiveEntries() {
        return this.entries.size();
    }

    public Enumeration getArchiveEntries() {
        return Collections.enumeration(this.entries.values());
    }

    public ArchiveEntry getArchiveEntry(String entryName) {
        return (TarEntry)this.entries.get(entryName);
    }

    public OutputStream getOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
        if (this.isBusy()) {
            throw new OutputArchiveBusyException(entry);
        }
        TarEntry tarEntry = (TarEntry)entry;
        if (tarEntry.isDirectory()) {
            tarEntry.setSize(0L);
            return new EntryOutputStream(tarEntry);
        }
        if (srcEntry != null) {
            tarEntry.setSize(srcEntry.getSize());
            return new EntryOutputStream(tarEntry);
        }
        java.io.File temp = Temps.createTempFile(TEMP_FILE_PREFIX);
        return new TempEntryOutputStream(tarEntry, temp);
    }

    private final boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntry(TarEntry entry, java.io.File temp) throws IOException {
        try {
            FileInputStream in = new FileInputStream(temp);
            try {
                this.putNextEntry(entry);
                try {
                    File.cat(in, (OutputStream)((Object)this));
                }
                finally {
                    this.closeEntry();
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        finally {
            if (!temp.delete()) {
                temp.deleteOnExit();
            }
        }
    }

    public final void storeDirectory(ArchiveEntry entry) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Since TrueZIP 6.5, this is not used anymore!");
        }
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(entry, null).close();
    }

    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OutputArchiveMetaData metaData) {
        this.metaData = metaData;
    }

    static {
        $assertionsDisabled = !TarOutputArchive.class.desiredAssertionStatus();
    }

    private class TempEntryOutputStream
    extends FileOutputStream {
        private final TarEntry entry;
        private final java.io.File temp;
        private boolean closed;

        public TempEntryOutputStream(TarEntry entry, java.io.File temp) throws IOException {
            super(temp);
            this.entry = entry;
            this.temp = temp;
            TarOutputArchive.this.entries.put(entry.getName(), entry);
            TarOutputArchive.this.busy = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputArchive.this.busy = false;
            try {
                super.close();
            }
            finally {
                this.entry.setSize(this.temp.length());
                TarOutputArchive.this.storeTempEntry(this.entry, this.temp);
            }
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private boolean closed;

        private EntryOutputStream(TarEntry entry) throws IOException {
            super((OutputStream)((Object)TarOutputArchive.this));
            TarOutputArchive.this.putNextEntry(entry);
            TarOutputArchive.this.entries.put(entry.getName(), entry);
            TarOutputArchive.this.busy = true;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputArchive.this.busy = false;
            TarOutputArchive.this.closeEntry();
        }
    }
}

