/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.dao.jdbc;

import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.lang.DoPrivilegedFactory;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLUtil;
import com.liferay.portal.security.pacl.dao.jdbc.PACLConnectionHandler;
import java.lang.reflect.InvocationHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class PACLDataSource
extends DataSourceWrapper {
    private DataSource _dataSource;

    public PACLDataSource(DataSource dataSource) {
        super(dataSource);
        this._dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this._dataSource.getConnection();
        PACLPolicy paclPolicy = PACLUtil.getPACLPolicy();
        if (paclPolicy == null) {
            return connection;
        }
        connection = (Connection)DoPrivilegedFactory.wrap((Object)connection);
        paclPolicy = (PACLPolicy)DoPrivilegedFactory.wrap((Object)paclPolicy);
        return AccessController.doPrivileged(new ConnectionPrivilegedAction(connection, paclPolicy));
    }

    private class ConnectionPrivilegedAction
    implements PrivilegedAction<Connection> {
        private Connection _connection;
        private PACLPolicy _paclPolicy;

        public ConnectionPrivilegedAction(Connection connection, PACLPolicy paclPolicy) {
            this._connection = connection;
            this._paclPolicy = paclPolicy;
        }

        @Override
        public Connection run() {
            return (Connection)ProxyUtil.newProxyInstance((ClassLoader)this._paclPolicy.getClassLoader(), (Class[])new Class[]{Connection.class}, (InvocationHandler)new PACLConnectionHandler(this._connection, this._paclPolicy));
        }
    }
}

