/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.PIFData;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarFileInputStream;
import org.hsqldb.lib.tar.TarHeaderField;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarReader {
    public static final int LIST_MODE = 0;
    public static final int EXTRACT_MODE = 1;
    public static final int OVERWRITE_MODE = 2;
    protected TarFileInputStream archive;
    protected Pattern[] patterns = null;
    protected int mode;
    protected File extractBaseDir;

    public static void main(String[] sa) throws IOException, TarMalformatException {
        int firstPatInd;
        if (sa.length < 1) {
            System.out.println(RB.TarReader_syntax.getString(TarReader.class.getName()));
            System.out.println(RB.listing_format.getString());
            System.exit(0);
        }
        File exDir = sa.length > 1 && sa[1].startsWith("--directory=") ? new File(sa[1].substring("--directory=".length())) : null;
        int n = firstPatInd = exDir == null ? 2 : 3;
        if (sa.length < firstPatInd || !sa[0].equals("t") && !sa[0].equals("x")) {
            throw new IllegalArgumentException(RB.tarreader_syntaxerr.getString(TarReader.class.getName()));
        }
        String[] patternStrings = null;
        if (sa.length > firstPatInd) {
            patternStrings = new String[sa.length - firstPatInd];
            for (int i = firstPatInd; i < sa.length; ++i) {
                patternStrings[i - firstPatInd] = sa[i];
            }
        }
        if (sa[0].equals("t") && exDir != null) {
            throw new IllegalArgumentException(RB.dir_x_conflict.getString());
        }
        int dirIndex = exDir == null ? 1 : 2;
        int tarReaderMode = sa[0].equals("t") ? 0 : 1;
        new TarReader(new File(sa[dirIndex]), tarReaderMode, patternStrings, null, exDir).read();
    }

    public TarReader(File inFile, int mode, String[] patternStrings, Integer readBufferBlocks, File inDir) throws IOException {
        this.mode = mode;
        File archiveFile = inFile.getAbsoluteFile();
        this.extractBaseDir = inDir == null ? null : inDir.getAbsoluteFile();
        int compression = 0;
        if (archiveFile.getName().endsWith(".tgz") || archiveFile.getName().endsWith(".gz")) {
            compression = 1;
        }
        if (patternStrings != null) {
            this.patterns = new Pattern[patternStrings.length];
            for (int i = 0; i < patternStrings.length; ++i) {
                this.patterns[i] = Pattern.compile(patternStrings[i]);
            }
        }
        this.archive = readBufferBlocks == null ? new TarFileInputStream(archiveFile, compression) : new TarFileInputStream(archiveFile, compression, readBufferBlocks);
    }

    public void read() throws IOException, TarMalformatException {
        boolean anyUnsupporteds = false;
        Long paxSize = null;
        String paxString = null;
        try {
            while (this.archive.readNextHeaderBlock()) {
                TarEntryHeader header = new TarEntryHeader(this.archive.readBuffer);
                char entryType = header.getEntryType();
                if (entryType == 'x') {
                    paxSize = this.getPifData(header).getSize();
                    paxString = header.toString();
                    continue;
                }
                if (paxSize != null) {
                    header.setDataSize(paxSize);
                    paxSize = null;
                }
                if (this.patterns != null) {
                    boolean matched = false;
                    for (int i = 0; i < this.patterns.length; ++i) {
                        if (!this.patterns[i].matcher(header.getPath()).matches()) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        paxString = null;
                        this.skipFileData(header);
                        continue;
                    }
                }
                if (entryType != '\u0000' && entryType != '0' && entryType != 'x') {
                    anyUnsupporteds = true;
                }
                switch (this.mode) {
                    case 0: {
                        if (paxString != null) {
                            System.out.println(paxString);
                        }
                        System.out.println(header.toString());
                        this.skipFileData(header);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (paxString != null) {
                            System.out.println(paxString);
                        }
                        System.out.println(header.toString());
                        if (entryType == '\u0000' || entryType == '0' || entryType == 'x') {
                            this.extractFile(header);
                            break;
                        }
                        this.skipFileData(header);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(RB.unsupported_mode.getString(this.mode));
                    }
                }
                paxString = null;
            }
            if (anyUnsupporteds) {
                System.out.println(RB.unsupported_entry_present.getString());
            }
        }
        catch (IOException ioe) {
            this.archive.close();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PIFData getPifData(TarEntryHeader header) throws IOException, TarMalformatException {
        long dataSize = header.getDataSize();
        if (dataSize < 1L) {
            throw new TarMalformatException(RB.pif_unknown_datasize.getString());
        }
        if (dataSize > Integer.MAX_VALUE) {
            throw new TarMalformatException(RB.pif_data_toobig.getString(Long.toString(dataSize), Integer.MAX_VALUE));
        }
        int modulus = (int)(dataSize % 512L);
        PipedInputStream inPipe = null;
        PipedOutputStream outPipe = new PipedOutputStream();
        try {
            try {
                int readNow;
                inPipe = new PipedInputStream(outPipe);
                for (int readBlocks = (int)(dataSize / 512L); readBlocks > 0; readBlocks -= readNow) {
                    readNow = readBlocks > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : readBlocks;
                    this.archive.readBlocks(readNow);
                    outPipe.write(this.archive.readBuffer, 0, readNow * 512);
                }
                if (modulus != 0) {
                    this.archive.readBlock();
                    outPipe.write(this.archive.readBuffer, 0, modulus);
                }
                outPipe.flush();
            }
            catch (IOException ioe) {
                if (inPipe == null) throw ioe;
                inPipe.close();
                throw ioe;
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            try {
                outPipe.close();
                Object var13_12 = null;
                outPipe = null;
                inPipe = null;
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var13_13 = null;
                outPipe = null;
                inPipe = null;
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            Object var13_11 = null;
            outPipe = null;
            inPipe = null;
            throw throwable;
        }
        outPipe.close();
        Object var13_10 = null;
        outPipe = null;
        inPipe = null;
        return new PIFData(inPipe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(TarEntryHeader header) throws IOException, TarMalformatException {
        Object v1;
        FileOutputStream outStream;
        File newFile;
        block18: {
            if (header.getDataSize() < 1L) {
                throw new TarMalformatException(RB.data_size_unknown.getString());
            }
            int readBlocks = (int)(header.getDataSize() / 512L);
            int modulus = (int)(header.getDataSize() % 512L);
            newFile = header.generateFile();
            if (!newFile.isAbsolute()) {
                newFile = this.extractBaseDir == null ? newFile.getAbsoluteFile() : new File(this.extractBaseDir, newFile.getPath());
            }
            File parentDir = newFile.getParentFile();
            if (newFile.exists()) {
                if (this.mode != 2) {
                    throw new IOException(RB.extraction_exists.getString(newFile.getAbsolutePath()));
                }
                if (!newFile.isFile()) {
                    throw new IOException(RB.extraction_exists_notfile.getString(newFile.getAbsolutePath()));
                }
            }
            if (parentDir.exists()) {
                if (!parentDir.isDirectory()) {
                    throw new IOException(RB.extraction_parent_not_dir.getString(parentDir.getAbsolutePath()));
                }
                if (!parentDir.canWrite()) {
                    throw new IOException(RB.extraction_parent_not_writable.getString(parentDir.getAbsolutePath()));
                }
            } else if (!parentDir.mkdirs()) {
                throw new IOException(RB.extraction_parent_mkfail.getString(parentDir.getAbsolutePath()));
            }
            int fileMode = header.getFileMode();
            outStream = new FileOutputStream(newFile);
            try {
                while (readBlocks > 0) {
                    int readNow = readBlocks > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : readBlocks;
                    this.archive.readBlocks(readNow);
                    readBlocks -= readNow;
                    outStream.write(this.archive.readBuffer, 0, readNow * 512);
                }
                if (modulus != 0) {
                    this.archive.readBlock();
                    outStream.write(this.archive.readBuffer, 0, modulus);
                }
                outStream.flush();
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var10_10 = null;
                try {
                    outStream.close();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var12_14 = v0;
                outStream = null;
                throw throwable;
            }
            try {
                outStream.close();
                v1 = null;
                break block18;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var12_13 = v1;
        outStream = null;
        newFile.setLastModified(header.getModTime() * 1000L);
        if (newFile.length() != header.getDataSize()) {
            throw new IOException(RB.write_count_mismatch.getString(Long.toString(header.getDataSize()), newFile.getAbsolutePath(), Long.toString(newFile.length())));
        }
    }

    protected void skipFileData(TarEntryHeader header) throws IOException, TarMalformatException {
        int skipNow;
        if (header.getDataSize() == 0L) {
            return;
        }
        if (header.getDataSize() < 0L) {
            throw new TarMalformatException(RB.data_size_unknown.getString());
        }
        int oddBlocks = header.getDataSize() % 512L == 0L ? 0 : 1;
        for (int skipBlocks = (int)(header.getDataSize() / 512L) + oddBlocks; skipBlocks > 0; skipBlocks -= skipNow) {
            skipNow = skipBlocks > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : skipBlocks;
            this.archive.readBlocks(skipNow);
        }
    }

    protected static class TarEntryHeader {
        protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        protected byte[] rawHeader;
        protected String path;
        protected int fileMode;
        protected long dataSize = -1L;
        protected long modTime;
        protected char entryType;
        protected String ownerName;
        protected boolean ustar;

        public TarEntryHeader(byte[] rawHeader) throws TarMalformatException {
            this.rawHeader = rawHeader;
            Long expectedCheckSum = this.readInteger(TarHeaderField.checksum);
            try {
                if (expectedCheckSum == null) {
                    throw new MissingField(TarHeaderField.checksum);
                }
                long calculatedCheckSum = this.headerChecksum();
                if (expectedCheckSum != calculatedCheckSum) {
                    throw new TarMalformatException(RB.checksum_mismatch.getString(expectedCheckSum.toString(), Long.toString(calculatedCheckSum)));
                }
                this.path = this.readString(TarHeaderField.name);
                if (this.path == null) {
                    throw new MissingField(TarHeaderField.name);
                }
                Long longObject = this.readInteger(TarHeaderField.mode);
                if (longObject == null) {
                    throw new MissingField(TarHeaderField.mode);
                }
                this.fileMode = (int)longObject.longValue();
                longObject = this.readInteger(TarHeaderField.size);
                if (longObject != null) {
                    this.dataSize = longObject;
                }
                if ((longObject = this.readInteger(TarHeaderField.mtime)) == null) {
                    throw new MissingField(TarHeaderField.mtime);
                }
                this.modTime = longObject;
            }
            catch (MissingField mf) {
                throw new TarMalformatException(mf.getMessage());
            }
            this.entryType = this.readChar(TarHeaderField.typeflag);
            this.ownerName = this.readString(TarHeaderField.uname);
            String pathPrefix = this.readString(TarHeaderField.prefix);
            if (pathPrefix != null) {
                this.path = pathPrefix + '/' + this.path;
            }
            this.ustar = this.isUstar();
        }

        public File generateFile() {
            if (this.entryType != '\u0000' && this.entryType != '0') {
                throw new IllegalStateException(RB.create_only_normal.getString());
            }
            return new File(this.path);
        }

        public char getEntryType() {
            return this.entryType;
        }

        public String getPath() {
            return this.path;
        }

        public void setDataSize(long dataSize) {
            this.dataSize = dataSize;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public long getModTime() {
            return this.modTime;
        }

        public int getFileMode() {
            return this.fileMode;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.sdf.format(new Long(this.modTime * 1000L)) + ' ');
            sb.append(this.entryType == '\u0000' ? (char)' ' : (char)this.entryType);
            sb.append(this.ustar ? (char)'*' : ' ');
            sb.append(" " + StringUtil.toPaddedString(Integer.toOctalString(this.fileMode), 4, ' ', false) + ' ' + StringUtil.toPaddedString(Long.toString(this.dataSize), 11, ' ', false) + "  ");
            sb.append(StringUtil.toPaddedString(this.ownerName == null ? "-" : this.ownerName, 8, ' ', true));
            sb.append("  " + this.path);
            return sb.toString();
        }

        public boolean isUstar() throws TarMalformatException {
            String magicString = this.readString(TarHeaderField.magic);
            return magicString != null && magicString.startsWith("ustar");
        }

        public static int indexOf(byte[] ba, byte val, int from, int to) {
            for (int i = from; i < to; ++i) {
                if (ba[i] != val) continue;
                return i - from;
            }
            return -1;
        }

        protected char readChar(TarHeaderField field) throws TarMalformatException {
            String s = this.readString(field);
            return s == null ? (char)'\u0000' : s.charAt(0);
        }

        protected String readString(TarHeaderField field) throws TarMalformatException {
            int start = field.getStart();
            int stop = field.getStop();
            int termIndex = TarEntryHeader.indexOf(this.rawHeader, (byte)0, start, stop);
            switch (termIndex) {
                case 0: {
                    return null;
                }
                case -1: {
                    termIndex = stop - start;
                }
            }
            try {
                return new String(this.rawHeader, start, termIndex);
            }
            catch (Throwable t) {
                throw new TarMalformatException(RB.bad_header_value.getString(field.toString()));
            }
        }

        protected Long readInteger(TarHeaderField field) throws TarMalformatException {
            String s = this.readString(field);
            if (s == null) {
                return null;
            }
            try {
                return Long.valueOf(s, 8);
            }
            catch (NumberFormatException nfe) {
                throw new TarMalformatException(RB.bad_numeric_header_value.getString(field.toString(), nfe.toString()));
            }
        }

        protected long headerChecksum() {
            long sum = 0L;
            for (int i = 0; i < 512; ++i) {
                boolean isInRange = i >= TarHeaderField.checksum.getStart() && i < TarHeaderField.checksum.getStop();
                sum += isInRange ? 32L : (long)(0xFF & this.rawHeader[i]);
            }
            return sum;
        }

        protected static class MissingField
        extends Exception {
            private TarHeaderField field;

            public MissingField(TarHeaderField field) {
                this.field = field;
            }

            public String getMessage() {
                return RB.header_field_missing.getString(this.field.toString());
            }
        }
    }
}

