/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.test;

import java.io.File;
import java.util.List;
import org.im4java.test.TestCase21;
import org.im4java.utils.BatchConverter;

public class TestCase22
extends TestCase21 {
    public String getDescription() {
        return "batch conversion";
    }

    public static void main(String[] stringArray) {
        TestCase22 testCase22 = new TestCase22();
        testCase22.runTest(stringArray);
    }

    public void run() throws Exception {
        System.err.println("22. Testing batch conversion  ...");
        BatchConverter.Mode mode = BatchConverter.Mode.SEQUENTIAL;
        if (this.iArgs != null && this.iArgs.length > 2) {
            if (this.iArgs[2].equals("par")) {
                mode = BatchConverter.Mode.PARALLEL;
            } else if (this.iArgs[2].equals("batch")) {
                mode = BatchConverter.Mode.BATCH;
            }
        }
        List<String> list = this.load();
        String string = iImageDir + ".thumbnails22" + File.separatorChar;
        new File(string).mkdir();
        MyBatchConverter myBatchConverter = new MyBatchConverter(mode, list);
        myBatchConverter.run(this.iOp, list, string + "%F");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyBatchConverter
    extends BatchConverter {
        private long iStartTime;
        private List<String> iImages;

        MyBatchConverter(BatchConverter.Mode mode, List<String> list) {
            super(mode);
            this.iImages = list;
            this.iStartTime = System.nanoTime();
        }

        @Override
        public void terminated() {
            double d = (double)(System.nanoTime() - this.iStartTime) / 1.0E9;
            System.err.println("Estimated elapsed time: " + d);
            System.err.println("conversion terminated\n");
            List<BatchConverter.ConvertException> list = this.getFailedConversions();
            if (list != null && list.size() > 0) {
                System.err.println("Failed images:");
                for (BatchConverter.ConvertException convertException : list) {
                    System.err.println("  " + this.iImages.get(convertException.getIndex()));
                    Throwable throwable = convertException.getCause();
                    if (throwable == null || throwable.getMessage() == null) continue;
                    System.err.println(" " + throwable.getMessage());
                }
            }
        }
    }
}

