/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.LazyItemIterator;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.VersionManagerImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.query.QueryManagerImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
extends ItemImpl
implements Node {
    private static Logger log = LoggerFactory.getLogger(NodeImpl.class);
    protected static final short CREATED = 0;
    private final AbstractNodeData data;

    protected NodeImpl(ItemManager itemMgr, SessionImpl session, AbstractNodeData data) {
        super(itemMgr, session, data);
        this.data = data;
        NodeTypeRegistry ntReg = session.getNodeTypeManager().getNodeTypeRegistry();
        NodeState state = data.getNodeState();
        if (!ntReg.isRegistered(state.getNodeTypeName())) {
            log.warn("Fallback to nt:unstructured due to unknown node type '" + state.getNodeTypeName() + "' of " + this);
            data.getNodeState().setNodeTypeName(NameConstants.NT_UNSTRUCTURED);
        }
        ArrayList<Name> unknown = null;
        for (Name mixinName : state.getMixinTypeNames()) {
            if (ntReg.isRegistered(mixinName)) continue;
            if (unknown == null) {
                unknown = new ArrayList<Name>();
            }
            unknown.add(mixinName);
            log.warn("Ignoring unknown mixin type '" + mixinName + "' of " + this);
        }
        if (unknown != null) {
            HashSet<Name> known = new HashSet<Name>(state.getMixinTypeNames());
            known.removeAll(unknown);
            state.setMixinTypeNames(known);
        }
    }

    NodeState getNodeState() {
        return this.data.getNodeState();
    }

    protected PropertyId resolveRelativePropertyPath(String relPath) throws RepositoryException {
        try {
            if (relPath.indexOf(47) == -1) {
                Name propName = this.session.getQName(relPath);
                NodeState thisState = this.data.getNodeState();
                if (thisState.hasPropertyName(propName)) {
                    return new PropertyId(thisState.getNodeId(), propName);
                }
                return null;
            }
            Path p = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), this.session.getQPath(relPath), true);
            return this.session.getHierarchyManager().resolvePropertyPath(p);
        }
        catch (NameException e) {
            String msg = "failed to resolve path " + relPath + " relative to " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected NodeId resolveRelativeNodePath(String relPath) throws RepositoryException {
        Path p = this.resolveRelativePath(relPath);
        return this.getNodeId(p);
    }

    private Path resolveRelativePath(String relPath) throws RepositoryException {
        try {
            return this.session.getQPath(relPath);
        }
        catch (NameException e) {
            String msg = "failed to resolve path " + relPath + " relative to " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private NodeId getNodeId(Path p) throws RepositoryException {
        Path.Element pe;
        if (p.getLength() == 1 && (pe = p.getNameElement()).denotesName()) {
            ChildNodeEntry cne;
            NodeState thisState = this.data.getNodeState();
            int index = pe.getIndex();
            if (index == 0) {
                index = 1;
            }
            if ((cne = thisState.getChildNodeEntry(pe.getName(), index)) != null) {
                return cne.getId();
            }
            return null;
        }
        p = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), p, true);
        return this.session.getHierarchyManager().resolveNodePath(p);
    }

    protected boolean hasPendingChanges() throws RepositoryException {
        if (this.isTransient()) {
            return true;
        }
        Iterator<ItemState> iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
        return iter.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized ItemState getOrCreateTransientItemState() throws RepositoryException {
        AbstractNodeData abstractNodeData = this.data;
        synchronized (abstractNodeData) {
            if (!this.isTransient()) {
                try {
                    NodeState transientState = this.stateMgr.createTransientNodeState((NodeState)this.stateMgr.getItemState(this.getId()), 2);
                    this.data.setState(transientState);
                }
                catch (ItemStateException ise) {
                    String msg = "failed to create transient state";
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)ise);
                }
            }
            return this.getItemState();
        }
    }

    protected PropertyImpl getOrCreateProperty(String name, int type, boolean multiValued, boolean exactTypeMatch, BitSet status) throws ConstraintViolationException, RepositoryException {
        try {
            return this.getOrCreateProperty(this.session.getQName(name), type, multiValued, exactTypeMatch, status);
        }
        catch (NameException e) {
            throw new RepositoryException("invalid property name: " + name, (Throwable)e);
        }
    }

    protected synchronized PropertyImpl getOrCreateProperty(Name name, int type, boolean multiValued, boolean exactTypeMatch, BitSet status) throws ConstraintViolationException, RepositoryException {
        status.clear();
        if (this.isNew() && !this.hasProperty(name)) {
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(name, type, multiValued, exactTypeMatch);
            PropertyImpl prop = this.createChildProperty(name, type, def);
            status.set(0);
            return prop;
        }
        try {
            PropertyId propId = new PropertyId(this.getNodeId(), name);
            return (PropertyImpl)this.itemMgr.getItem(propId);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(name.toString());
        }
        catch (ItemNotFoundException e) {
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(name, type, multiValued, exactTypeMatch);
            PropertyImpl prop = this.createChildProperty(name, type, def);
            status.set(0);
            return prop;
        }
    }

    protected synchronized PropertyImpl createChildProperty(Name name, int type, PropertyDefinitionImpl def) throws RepositoryException {
        PropertyState propState;
        try {
            QPropertyDefinition propDef = def.unwrap();
            if (def.getRequiredType() != 0) {
                type = def.getRequiredType();
            }
            propState = this.stateMgr.createTransientPropertyState(this.getNodeId(), name, 4);
            propState.setType(type);
            propState.setMultiValued(propDef.isMultiple());
            InternalValue[] genValues = this.session.getNodeTypeInstanceHandler().computeSystemGeneratedPropertyValues(this.data.getNodeState(), propDef);
            if (genValues == null) {
                genValues = InternalValue.create(propDef.getDefaultValues());
            }
            if (genValues != null) {
                propState.setValues(genValues);
            }
        }
        catch (ItemStateException ise) {
            String msg = "failed to add property " + name + " to " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        PropertyImpl prop = (PropertyImpl)this.itemMgr.createItemInstance(propState);
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addPropertyName(name);
        return prop;
    }

    protected synchronized NodeImpl createChildNode(Name name, NodeTypeImpl nodeType, NodeId id) throws RepositoryException {
        NodeImpl node;
        NodeState nodeState;
        try {
            if (id == null) {
                id = new NodeId();
            }
            nodeState = this.stateMgr.createTransientNodeState(id, nodeType.getQName(), this.getNodeId(), 4);
        }
        catch (ItemStateException ise) {
            String msg = "failed to add child node " + name + " to " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        try {
            node = (NodeImpl)this.itemMgr.createItemInstance(nodeState);
        }
        catch (RepositoryException re) {
            this.stateMgr.disposeTransientItemState(nodeState);
            throw re;
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addChildNodeEntry(name, nodeState.getNodeId());
        for (PropertyDefinition propertyDefinition : nodeType.getAutoCreatedPropertyDefinitions()) {
            PropertyDefinitionImpl pd = (PropertyDefinitionImpl)propertyDefinition;
            node.createChildProperty(pd.unwrap().getName(), pd.getRequiredType(), pd);
        }
        for (PropertyDefinition propertyDefinition : nodeType.getAutoCreatedNodeDefinitions()) {
            NodeDefinitionImpl nd = (NodeDefinitionImpl)propertyDefinition;
            node.createChildNode(nd.unwrap().getName(), (NodeTypeImpl)nd.getDefaultPrimaryType(), null);
        }
        return node;
    }

    protected void renameChildNode(Name oldName, int index, NodeId id, Name newName) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.renameChildNodeEntry(oldName, index, newName);
    }

    protected void removeChildProperty(String propName) throws RepositoryException {
        try {
            this.removeChildProperty(this.session.getQName(propName));
        }
        catch (NameException e) {
            throw new RepositoryException("invalid property name: " + propName, (Throwable)e);
        }
    }

    protected void removeChildProperty(Name propName) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (!thisState.removePropertyName(propName)) {
            String msg = "failed to remove property " + propName + " of " + this;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        PropertyId propId = new PropertyId(thisState.getNodeId(), propName);
        this.itemMgr.getItem(propId).setRemoved();
    }

    protected void removeChildNode(NodeId childId) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        ChildNodeEntry entry = thisState.getChildNodeEntry(childId);
        if (entry == null) {
            String msg = "failed to remove child " + childId + " of " + this;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeImpl childNode = this.itemMgr.getNode(childId, this.getNodeId());
        childNode.onRemove(this.getNodeId());
        if (!thisState.removeChildNodeEntry(childId)) {
            String msg = "failed to remove child " + childId + " of " + this;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
    }

    protected void onRedefine(QNodeDefinition def) throws RepositoryException {
        NodeDefinitionImpl newDef = this.session.getNodeTypeManager().getNodeDefinition(def);
        this.getOrCreateTransientItemState();
        this.data.setDefinition((ItemDefinition)newDef);
    }

    protected void onRemove(NodeId parentId) throws RepositoryException {
        AbstractCollection tmp;
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (thisState.isShareable() && thisState.removeShare(parentId) > 0) {
            this.data.setStatus(3);
            this.itemMgr.itemInvalidated(this.id, this.data);
            return;
        }
        if (thisState.hasChildNodeEntries()) {
            tmp = new ArrayList<ChildNodeEntry>(thisState.getChildNodeEntries());
            for (int i = ((ArrayList)tmp).size() - 1; i >= 0; --i) {
                ChildNodeEntry entry = (ChildNodeEntry)((ArrayList)tmp).get(i);
                NodeId childId = entry.getId();
                NodeImpl childNode = this.itemMgr.getNode(childId, this.getNodeId());
                childNode.onRemove(thisState.getNodeId());
                thisState.removeChildNodeEntry(childId);
            }
        }
        tmp = new HashSet<Name>(thisState.getPropertyNames());
        for (Name propName : tmp) {
            thisState.removePropertyName(propName);
            PropertyId propId = new PropertyId(thisState.getNodeId(), propName);
            this.itemMgr.getItem(propId).setRemoved();
        }
        thisState.setParentId(null);
        this.setRemoved();
    }

    private void setMixinTypesProperty(Set<Name> mixinNames) throws RepositoryException {
        PropertyImpl prop;
        NodeState thisState = this.data.getNodeState();
        if (thisState.hasPropertyName(NameConstants.JCR_MIXINTYPES)) {
            prop = (PropertyImpl)this.itemMgr.getItem(new PropertyId(thisState.getNodeId(), NameConstants.JCR_MIXINTYPES));
        } else {
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(NameConstants.JCR_MIXINTYPES, 7, true, true);
            prop = this.createChildProperty(NameConstants.JCR_MIXINTYPES, 7, def);
        }
        if (mixinNames.isEmpty()) {
            this.removeChildProperty(NameConstants.JCR_MIXINTYPES);
            return;
        }
        InternalValue[] vals = new InternalValue[mixinNames.size()];
        Iterator<Name> iter = mixinNames.iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            vals[cnt++] = InternalValue.create(iter.next());
        }
        prop.internalSetValue(vals, 7);
    }

    public Set<Name> getMixinTypeNames() {
        return this.data.getNodeState().getMixinTypeNames();
    }

    public EffectiveNodeType getEffectiveNodeType() throws RepositoryException {
        try {
            NodeTypeRegistry registry = this.session.getNodeTypeManager().getNodeTypeRegistry();
            return registry.getEffectiveNodeType(this.data.getNodeState().getNodeTypeName(), this.data.getNodeState().getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "Failed to build effective node type for " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    protected NodeDefinitionImpl getApplicableChildNodeDefinition(Name nodeName, Name nodeTypeName) throws ConstraintViolationException, RepositoryException {
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        QNodeDefinition cnd = this.getEffectiveNodeType().getApplicableChildNodeDef(nodeName, nodeTypeName, ntMgr.getNodeTypeRegistry());
        return ntMgr.getNodeDefinition(cnd);
    }

    protected PropertyDefinitionImpl getApplicablePropertyDefinition(Name propertyName, int type, boolean multiValued, boolean exactTypeMatch) throws ConstraintViolationException, RepositoryException {
        QPropertyDefinition pd;
        if (exactTypeMatch || type == 0) {
            pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, type, multiValued);
        } else {
            try {
                pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, type, multiValued);
            }
            catch (ConstraintViolationException cve) {
                pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, 0, multiValued);
            }
        }
        return this.session.getNodeTypeManager().getPropertyDefinition(pd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void makePersistent() throws InvalidItemStateException {
        if (!this.isTransient()) {
            log.debug(this + " (" + this.id + "): there's no transient state to persist");
            return;
        }
        NodeState transientState = this.data.getNodeState();
        NodeState persistentState = (NodeState)transientState.getOverlayedState();
        if (persistentState == null) {
            persistentState = this.stateMgr.createNew(transientState);
        }
        NodeState nodeState = persistentState;
        synchronized (nodeState) {
            if (transientState.isStale()) {
                String msg = this + ": the node cannot be saved because it has been" + " modified externally.";
                log.debug(msg);
                throw new InvalidItemStateException(msg);
            }
            persistentState.setParentId(transientState.getParentId());
            persistentState.setNodeTypeName(transientState.getNodeTypeName());
            persistentState.setMixinTypeNames(transientState.getMixinTypeNames());
            persistentState.setChildNodeEntries(transientState.getChildNodeEntries());
            persistentState.setPropertyNames(transientState.getPropertyNames());
            persistentState.setSharedSet(transientState.getSharedSet());
            this.stateMgr.store(persistentState);
        }
        this.stateMgr.disconnectTransientItemState(transientState);
        this.data.setState(persistentState);
        this.data.setStatus(0);
        if (this.isShareable() && this.data.getPrimaryParentId() == null) {
            this.data.setPrimaryParentId(persistentState.getParentId());
        }
    }

    protected void restoreTransient(NodeState transientState) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (transientState.getStatus() == 4 && thisState.getStatus() != 4) {
            thisState.setStatus(4);
            this.stateMgr.disconnectTransientItemState(thisState);
        }
        thisState.setParentId(transientState.getParentId());
        thisState.setNodeTypeName(transientState.getNodeTypeName());
        thisState.setMixinTypeNames(transientState.getMixinTypeNames());
        thisState.setChildNodeEntries(transientState.getChildNodeEntries());
        thisState.setPropertyNames(transientState.getPropertyNames());
        thisState.setSharedSet(transientState.getSharedSet());
    }

    public void addMixin(Name mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        EffectiveNodeType entExisting;
        this.sanityCheck();
        int options = 150;
        int permissions = 128;
        if (NameConstants.MIX_VERSIONABLE.equals(mixinName) || NameConstants.MIX_SIMPLE_VERSIONABLE.equals(mixinName)) {
            permissions |= 0x100;
        }
        this.session.getValidator().checkModify(this, options, permissions);
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl mixin = ntMgr.getNodeType(mixinName);
        if (!mixin.isMixin()) {
            throw new RepositoryException(mixinName + ": not a mixin node type");
        }
        Name primaryTypeName = this.data.getNodeState().getNodeTypeName();
        NodeTypeImpl primaryType = ntMgr.getNodeType(primaryTypeName);
        if (primaryType.isDerivedFrom(mixinName)) {
            return;
        }
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            HashSet<Name> mixins = new HashSet<Name>(this.data.getNodeState().getMixinTypeNames());
            entExisting = ntReg.getEffectiveNodeType(primaryTypeName, mixins);
            if (entExisting.includesNodeType(mixinName)) {
                return;
            }
            mixins.add(mixinName);
            ntReg.getEffectiveNodeType(primaryTypeName, mixins);
        }
        catch (NodeTypeConflictException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        try {
            NodeTypeImpl declaringNT;
            NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
            HashSet<Name> mixins = new HashSet<Name>(thisState.getMixinTypeNames());
            mixins.add(mixinName);
            thisState.setMixinTypeNames(mixins);
            this.setMixinTypesProperty(mixins);
            for (PropertyDefinition propertyDefinition : mixin.getAutoCreatedPropertyDefinitions()) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)propertyDefinition;
                declaringNT = (NodeTypeImpl)pd.getDeclaringNodeType();
                if (entExisting.includesNodeType(declaringNT.getQName())) continue;
                this.createChildProperty(pd.unwrap().getName(), pd.getRequiredType(), pd);
            }
            for (PropertyDefinition propertyDefinition : mixin.getAutoCreatedNodeDefinitions()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)propertyDefinition;
                declaringNT = (NodeTypeImpl)nd.getDeclaringNodeType();
                if (entExisting.includesNodeType(declaringNT.getQName())) continue;
                this.createChildNode(nd.unwrap().getName(), (NodeTypeImpl)nd.getDefaultPrimaryType(), null);
            }
        }
        catch (RepositoryException re) {
            try {
                this.removeMixin(mixinName);
            }
            catch (RepositoryException re1) {
                // empty catch block
            }
            throw re;
        }
    }

    public void removeMixin(Name mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        PropertyDefinitionImpl oldDef;
        PropertyIterator iter;
        EffectiveNodeType entResulting;
        this.sanityCheck();
        int options = 150;
        int permissions = 128;
        this.session.getValidator().checkModify(this, options, permissions);
        NodeState state = this.data.getNodeState();
        if (!state.getMixinTypeNames().contains(mixinName)) {
            throw new NoSuchNodeTypeException();
        }
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        HashSet<Name> remainingMixins = new HashSet<Name>(state.getMixinTypeNames());
        remainingMixins.remove(mixinName);
        try {
            entResulting = ntReg.getEffectiveNodeType(state.getNodeTypeName(), remainingMixins);
        }
        catch (NodeTypeConflictException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        NodeTypeImpl mixin = ntMgr.getNodeType(mixinName);
        if ((NameConstants.MIX_REFERENCEABLE.equals(mixinName) || mixin.isDerivedFrom(NameConstants.MIX_REFERENCEABLE)) && !entResulting.includesNodeType(NameConstants.MIX_REFERENCEABLE) && (iter = this.getReferences()).hasNext()) {
            throw new ConstraintViolationException(mixinName + " can not be removed: the node is being referenced" + " through at least one property of type REFERENCE");
        }
        if ((NameConstants.MIX_LOCKABLE.equals(mixinName) || mixin.isDerivedFrom(NameConstants.MIX_LOCKABLE)) && !entResulting.includesNodeType(NameConstants.MIX_LOCKABLE) && this.isLocked()) {
            throw new ConstraintViolationException(mixinName + " can not be removed: the node is locked.");
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        HashMap<PropertyId, PropertyDefinitionImpl> affectedProps = new HashMap<PropertyId, PropertyDefinitionImpl>();
        HashMap<ChildNodeEntry, PropertyDefinitionImpl> affectedNodes = new HashMap<ChildNodeEntry, PropertyDefinitionImpl>();
        try {
            NodeTypeImpl declaringNT;
            Set<Name> names = thisState.getPropertyNames();
            for (Name propName : names) {
                PropertyId propId = new PropertyId(thisState.getNodeId(), propName);
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(propId);
                oldDef = this.itemMgr.getDefinition(propState);
                declaringNT = (NodeTypeImpl)oldDef.getDeclaringNodeType();
                if (entResulting.includesNodeType(declaringNT.getQName())) continue;
                affectedProps.put(propId, oldDef);
            }
            List<ChildNodeEntry> entries = thisState.getChildNodeEntries();
            for (ChildNodeEntry entry : entries) {
                NodeState nodeState = (NodeState)this.stateMgr.getItemState(entry.getId());
                oldDef = this.itemMgr.getDefinition(nodeState);
                declaringNT = (NodeTypeImpl)oldDef.getDeclaringNodeType();
                if (entResulting.includesNodeType(declaringNT.getQName())) continue;
                affectedNodes.put(entry, oldDef);
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Internal Error: Failed to determine effect of removing mixin " + this.session.getJCRName(mixinName), (Throwable)e);
        }
        thisState.setMixinTypeNames(remainingMixins);
        this.setMixinTypesProperty(remainingMixins);
        boolean success = false;
        try {
            for (PropertyId id : affectedProps.keySet()) {
                PropertyImpl prop = (PropertyImpl)this.itemMgr.getItem(id);
                PropertyDefinition oldDef2 = (PropertyDefinition)affectedProps.get(id);
                if (oldDef2.isProtected()) {
                    this.removeChildProperty(id.getName());
                    continue;
                }
                try {
                    PropertyDefinitionImpl newDef = this.getApplicablePropertyDefinition(id.getName(), prop.getType(), oldDef2.isMultiple(), false);
                    if (newDef.getRequiredType() != 0 && newDef.getRequiredType() != prop.getType()) {
                        if (oldDef2.isMultiple()) {
                            Value[] values = ValueHelper.convert((Value[])prop.getValues(), (int)newDef.getRequiredType(), (ValueFactory)this.session.getValueFactory());
                            prop.onRedefine(newDef.unwrap());
                            prop.setValue(values);
                            continue;
                        }
                        Value value = ValueHelper.convert((Value)prop.getValue(), (int)newDef.getRequiredType(), (ValueFactory)this.session.getValueFactory());
                        prop.onRedefine(newDef.unwrap());
                        prop.setValue(value);
                        continue;
                    }
                    prop.onRedefine(newDef.unwrap());
                }
                catch (ValueFormatException vfe) {
                    this.removeChildProperty(id.getName());
                }
                catch (ConstraintViolationException cve) {
                    this.removeChildProperty(id.getName());
                }
            }
            for (ChildNodeEntry entry : affectedNodes.keySet()) {
                NodeState nodeState = (NodeState)this.stateMgr.getItemState(entry.getId());
                NodeImpl node = (NodeImpl)this.itemMgr.getItem(entry.getId());
                oldDef = (NodeDefinition)affectedNodes.get(entry);
                if (oldDef.isProtected()) {
                    this.removeChildNode(entry.getId());
                    continue;
                }
                try {
                    NodeDefinitionImpl newDef = this.getApplicableChildNodeDefinition(entry.getName(), nodeState.getNodeTypeName());
                    node.onRedefine(newDef.unwrap());
                }
                catch (ConstraintViolationException cve) {
                    this.removeChildNode(entry.getId());
                }
            }
            success = true;
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Failed to clean up child items defined by removed mixin " + this.session.getJCRName(mixinName), (Throwable)e);
        }
        finally {
            if (!success) {
                // empty if block
            }
        }
    }

    public boolean isNodeType(Name ntName) throws RepositoryException {
        this.sanityCheck();
        Name primary = this.data.getNodeState().getNodeTypeName();
        if (ntName.equals(primary)) {
            return true;
        }
        Set<Name> mixins = this.data.getNodeState().getMixinTypeNames();
        if (mixins.contains(ntName)) {
            return true;
        }
        try {
            NodeTypeRegistry registry = this.session.getNodeTypeManager().getNodeTypeRegistry();
            EffectiveNodeType type = registry.getEffectiveNodeType(primary, mixins);
            return type.includesNodeType(ntName);
        }
        catch (NodeTypeConflictException e) {
            String msg = "Failed to build effective node type for " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected void checkSetProperty() throws VersionException, LockException, RepositoryException {
        int options = 6;
        this.session.getValidator().checkModify(this, options, 0);
    }

    protected Property internalSetProperty(Name name, InternalValue value) throws ValueFormatException, RepositoryException {
        int type = value == null ? 0 : value.getType();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, true, status);
        try {
            if (value == null) {
                prop.internalSetValue(null, type);
            } else {
                prop.internalSetValue(new InternalValue[]{value}, type);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    protected Property internalSetProperty(Name name, InternalValue[] values) throws ValueFormatException, RepositoryException {
        int type = values == null || values.length == 0 || values[0] == null ? 0 : values[0].getType();
        return this.internalSetProperty(name, values, type);
    }

    protected Property internalSetProperty(Name name, InternalValue[] values, int type) throws ValueFormatException, RepositoryException {
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, true, status);
        try {
            prop.internalSetValue(values, type);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public NodeImpl getNode(Name name) throws ItemNotFoundException, RepositoryException {
        return this.getNode(name, 1);
    }

    public NodeImpl getNode(Name name, int index) throws ItemNotFoundException, RepositoryException {
        ChildNodeEntry cne;
        this.sanityCheck();
        NodeState thisState = this.data.getNodeState();
        if (index == 0) {
            index = 1;
        }
        if ((cne = thisState.getChildNodeEntry(name, index)) == null) {
            throw new ItemNotFoundException();
        }
        try {
            return this.itemMgr.getNode(cne.getId(), this.getNodeId());
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException();
        }
    }

    public boolean hasNode(Name name) throws RepositoryException {
        return this.hasNode(name, 1);
    }

    public boolean hasNode(Name name, int index) throws RepositoryException {
        ChildNodeEntry cne;
        this.sanityCheck();
        NodeState thisState = this.data.getNodeState();
        if (index == 0) {
            index = 1;
        }
        if ((cne = thisState.getChildNodeEntry(name, index)) == null) {
            return false;
        }
        return this.itemMgr.itemExists(cne.getId());
    }

    public PropertyImpl getProperty(Name name) throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        PropertyId propId = new PropertyId(this.getNodeId(), name);
        try {
            return (PropertyImpl)this.itemMgr.getItem(propId);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(name.toString());
        }
    }

    public boolean hasProperty(Name name) throws RepositoryException {
        this.sanityCheck();
        NodeState thisState = this.data.getNodeState();
        if (!thisState.hasPropertyName(name)) {
            return false;
        }
        PropertyId propId = new PropertyId(thisState.getNodeId(), name);
        return this.itemMgr.itemExists(propId);
    }

    public synchronized NodeImpl addNode(Name nodeName, Name nodeTypeName, NodeId id) throws RepositoryException {
        NodeState thisState;
        ChildNodeEntry cne;
        NodeDefinitionImpl def;
        this.sanityCheck();
        Path nodePath = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), nodeName, true);
        NodeTypeImpl nt = null;
        if (nodeTypeName != null) {
            nt = this.session.getNodeTypeManager().getNodeType(nodeTypeName);
            if (nt.isMixin()) {
                throw new ConstraintViolationException("Unable to add a node with a mixin node type: " + this.session.getJCRName(nodeTypeName));
            }
            if (nt.isAbstract()) {
                throw new ConstraintViolationException("Unable to add a node with an abstract node type: " + this.session.getJCRName(nodeTypeName));
            }
            this.session.getAccessManager().checkPermission(nodePath, 128);
        }
        try {
            def = this.getApplicableChildNodeDefinition(nodeName, nodeTypeName);
        }
        catch (RepositoryException e) {
            throw new ConstraintViolationException("No child node definition for " + this.session.getJCRName(nodeName) + " found in " + this, (Throwable)e);
        }
        if (nt == null) {
            nt = (NodeTypeImpl)def.getDefaultPrimaryType();
        }
        if ((cne = (thisState = this.data.getNodeState()).getChildNodeEntry(nodeName, 1)) != null) {
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException("This node already exists: " + this.itemMgr.safeGetJCRPath(nodePath));
            }
            NodeImpl existing = this.itemMgr.getNode(cne.getId(), this.getNodeId());
            if (!existing.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException("Same-name siblings not allowed for " + existing);
            }
        }
        int options = 406;
        this.session.getValidator().checkModify(this, options, 0);
        return this.createChildNode(nodeName, nt, id);
    }

    public PropertyImpl setProperty(Name name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        int type = 0;
        if (values != null) {
            for (Value v : values) {
                if (v == null) continue;
                type = v.getType();
                break;
            }
        }
        return this.setProperty(name, values, type, false);
    }

    public PropertyImpl setProperty(Name name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, values, type, true);
    }

    public PropertyImpl setProperty(Name name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, value, false);
    }

    @Override
    public Name getQName() throws RepositoryException {
        HierarchyManager hierMgr = this.session.getHierarchyManager();
        Name name = !this.isShareable() ? hierMgr.getName(this.id) : hierMgr.getName(this.getNodeId(), this.getParentId());
        return name;
    }

    public NodeId getNodeId() {
        return (NodeId)this.id;
    }

    public synchronized void orderBefore(Path.Element srcName, Path.Element dstName) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.sanityCheck();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException("child node ordering not supported on " + this);
        }
        if (srcName.equals(dstName)) {
            return;
        }
        if (!this.hasNode(srcName.getName(), srcName.getIndex())) {
            String name;
            try {
                Path.Element[] path = new Path.Element[]{srcName};
                name = this.session.getJCRPath(new PathBuilder(path).getPath());
            }
            catch (NameException e) {
                name = srcName.toString();
            }
            catch (NamespaceException e) {
                name = srcName.toString();
            }
            throw new ItemNotFoundException(this + " has no child node with name " + name);
        }
        if (dstName != null && !this.hasNode(dstName.getName(), dstName.getIndex())) {
            String name;
            try {
                Path.Element[] path = new Path.Element[]{dstName};
                name = this.session.getJCRPath(new PathBuilder(path).getPath());
            }
            catch (NameException e) {
                name = dstName.toString();
            }
            catch (NamespaceException e) {
                name = dstName.toString();
            }
            throw new ItemNotFoundException(this + " has no child node with name " + name);
        }
        int options = 22;
        this.session.getValidator().checkModify(this, options, 0);
        AccessManager acMgr = this.session.getAccessManager();
        PathBuilder pb = new PathBuilder(this.getPrimaryPath());
        pb.addLast(srcName.getName(), srcName.getIndex());
        Path childPath = pb.getPath();
        if (!acMgr.isGranted(childPath, 12)) {
            String msg = "Not allowed to reorder child node " + this.session.getJCRPath(childPath) + ".";
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
        ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(this.data.getNodeState().getChildNodeEntries());
        int srcInd = -1;
        int destInd = -1;
        for (int i = 0; i < list.size(); ++i) {
            ChildNodeEntry entry = list.get(i);
            if (srcInd == -1 && entry.getName().equals(srcName.getName()) && (entry.getIndex() == srcName.getIndex() || srcName.getIndex() == 0 && entry.getIndex() == 1)) {
                srcInd = i;
            }
            if (destInd == -1 && dstName != null) {
                if (!entry.getName().equals(dstName.getName()) || entry.getIndex() != dstName.getIndex() && (dstName.getIndex() != 0 || entry.getIndex() != 1)) continue;
                destInd = i;
                if (srcInd == -1) continue;
                break;
            }
            if (srcInd != -1) break;
        }
        if (destInd == -1 ? srcInd == list.size() - 1 : destInd - srcInd == 1) {
            return;
        }
        if (destInd == -1) {
            list.add(list.remove(srcInd));
        } else if (srcInd < destInd) {
            list.add(destInd, list.get(srcInd));
            list.remove(srcInd);
        } else {
            list.add(destInd, list.remove(srcInd));
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setChildNodeEntries(list);
    }

    public synchronized NodeImpl replaceChildNode(NodeId id, Name nodeName, Name nodeTypeName, Name[] mixinNames) throws ItemNotFoundException, NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.sanityCheck();
        Node existing = (Node)this.itemMgr.getItem(id);
        NodeState state = this.data.getNodeState();
        ChildNodeEntry cneExisting = state.getChildNodeEntry(id);
        if (cneExisting == null) {
            throw new ItemNotFoundException(this + ": no child node entry with id " + id);
        }
        ArrayList<ChildNodeEntry> cneList = new ArrayList<ChildNodeEntry>(state.getChildNodeEntries());
        existing.remove();
        NodeImpl node = this.addNode(nodeName, nodeTypeName, id);
        if (mixinNames != null) {
            for (Name mixinName : mixinNames) {
                node.addMixin(mixinName);
            }
        }
        state = this.data.getNodeState();
        if (cneExisting.getName().equals(nodeName)) {
            state.setChildNodeEntries(cneList);
        } else {
            state.removeAllChildNodeEntries();
            for (ChildNodeEntry cne : cneList) {
                if (cne.getId().equals(id)) {
                    state.addChildNodeEntry(nodeName, id);
                    continue;
                }
                state.addChildNodeEntry(cne.getName(), cne.getId());
            }
        }
        return node;
    }

    public synchronized NodeImpl clone(NodeImpl src, Name name) throws ItemExistsException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        NodeDefinitionImpl def;
        Path nodePath;
        try {
            nodePath = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), name, true);
        }
        catch (MalformedPathException e) {
            String msg = "internal error: invalid path " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        int options = 22;
        this.session.getValidator().checkModify(this, options, 0);
        try {
            def = this.getApplicableChildNodeDefinition(name, null);
        }
        catch (RepositoryException re) {
            String msg = "no definition found in parent node's node type for new node";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        NodeState thisState = this.data.getNodeState();
        ChildNodeEntry cne = thisState.getChildNodeEntry(name, 1);
        if (cne != null) {
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException(this.itemMgr.safeGetJCRPath(nodePath));
            }
            NodeId newId = cne.getId();
            if (!((NodeImpl)this.itemMgr.getItem(newId)).getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException(this.itemMgr.safeGetJCRPath(nodePath));
            }
        }
        NodeId parentId = this.getNodeId();
        src.addShareParent(parentId);
        NodeId srcId = src.getNodeId();
        thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addChildNodeEntry(name, srcId);
        return this.itemMgr.getNode(srcId, parentId);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public String getName() throws RepositoryException {
        this.sanityCheck();
        NodeState state = this.data.getNodeState();
        if (state.getParentId() == null) {
            return "";
        }
        HierarchyManager hierMgr = this.session.getHierarchyManager();
        Name name = !this.isShareable() ? hierMgr.getName(this.id) : hierMgr.getName(this.getNodeId(), this.getParentId());
        return this.session.getJCRName(name);
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.sanityCheck();
        visitor.visit((Node)this);
    }

    @Override
    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        NodeId parentId = this.getParentId();
        if (parentId == null) {
            String msg = "root node doesn't have a parent";
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        return (Node)this.itemMgr.getItem(parentId);
    }

    public Node addNode(String relPath) throws RepositoryException {
        return this.addNodeWithUuid(relPath, null, null);
    }

    public Node addNode(String relPath, String nodeTypeName) throws RepositoryException {
        return this.addNodeWithUuid(relPath, nodeTypeName, null);
    }

    public Node addNodeWithUuid(String relPath, String uuid) throws RepositoryException {
        return this.addNodeWithUuid(relPath, null, uuid);
    }

    public synchronized Node addNodeWithUuid(String relPath, String nodeTypeName, String uuid) throws RepositoryException {
        NodeImpl parentNode;
        Path path;
        this.sanityCheck();
        try {
            path = PathFactoryImpl.getInstance().create(this.getPrimaryPath(), this.session.getQPath(relPath), true);
        }
        catch (NameException e) {
            throw new RepositoryException("Failed to resolve path " + relPath + " relative to " + this, (Throwable)e);
        }
        Path.Element last = path.getNameElement();
        if (!last.denotesName() || last.getIndex() != 0) {
            throw new RepositoryException("Invalid last path element for adding node " + relPath + " relative to " + this);
        }
        Path parentPath = path.getAncestor(1);
        try {
            parentNode = this.itemMgr.getNode(parentPath);
        }
        catch (PathNotFoundException e) {
            if (this.itemMgr.propertyExists(parentPath)) {
                throw new ConstraintViolationException("Unable to add a child node to property " + this.session.getJCRPath(parentPath));
            }
            throw e;
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException("Failed to resolve path " + relPath + " relative to " + this);
        }
        Name typeName = null;
        if (nodeTypeName != null) {
            typeName = this.session.getQName(nodeTypeName);
        }
        NodeId id = null;
        if (uuid != null && this.itemMgr.itemExists(id = new NodeId(uuid))) {
            throw new ItemExistsException("A node with this UUID already exists: " + uuid);
        }
        return parentNode.addNode(last.getName(), typeName, id);
    }

    public void orderBefore(String srcName, String destName) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        Path.Element beforeName;
        Path.Element insertName;
        try {
            Path p = this.session.getQPath(srcName);
            if (p.isAbsolute() || p.getLength() != 1 || p.getDepth() != 1) {
                throw new RepositoryException("invalid name: " + srcName);
            }
            insertName = p.getNameElement();
        }
        catch (NameException e) {
            String msg = "invalid name: " + srcName;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        if (destName != null) {
            try {
                Path p = this.session.getQPath(destName);
                if (p.isAbsolute() || p.getLength() != 1 || p.getDepth() != 1) {
                    throw new RepositoryException("invalid name: " + destName);
                }
                beforeName = p.getNameElement();
            }
            catch (NameException e) {
                String msg = "invalid name: " + destName;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
        } else {
            beforeName = null;
        }
        this.orderBefore(insertName, beforeName);
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(this.session.getQName(name), values);
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(this.session.getQName(name), values, type);
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] v = null;
        if (values != null) {
            v = ValueHelper.convert((String[])values, (int)1, (ValueFactory)this.session.getValueFactory());
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] v = null;
        if (values != null) {
            v = ValueHelper.convert((String[])values, (int)type, (ValueFactory)this.session.getValueFactory());
        }
        return this.setProperty(this.session.getQName(name), v, type, true);
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.session.getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.session.getValueFactory().createValue(value, type);
        }
        return this.setProperty(this.session.getQName(name), v, true);
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value != null) {
            value = ValueHelper.convert((Value)value, (int)type, (ValueFactory)this.session.getValueFactory());
        }
        return this.setProperty(this.session.getQName(name), value, true);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(this.session.getQName(name), value);
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.session.getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = this.session.getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = this.session.getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = this.session.getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            try {
                v = this.session.getValueFactory().createValue(value);
            }
            catch (IllegalArgumentException e) {
                throw new ValueFormatException(e.getMessage());
            }
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            try {
                v = this.session.getValueFactory().createValue(value);
            }
            catch (UnsupportedRepositoryOperationException e) {
                throw new ValueFormatException("node is not of type mix:referenceable");
            }
        }
        return this.setProperty(name, v);
    }

    protected PropertyImpl setProperty(Name name, Value value, boolean enforceType) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        int type = 0;
        if (value != null) {
            type = value.getType();
        }
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, enforceType, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    protected PropertyImpl setProperty(Name name, Value[] values, int type, boolean enforceType) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, enforceType, status);
        try {
            prop.setValue(values, type);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        Path p = this.resolveRelativePath(relPath);
        NodeId id = this.getNodeId(p);
        if (id == null) {
            throw new PathNotFoundException(relPath);
        }
        NodeId parentId = null;
        if (!p.denotesRoot()) {
            parentId = this.getNodeId(p.getAncestor(1));
        }
        try {
            if (parentId == null) {
                return (NodeImpl)this.itemMgr.getItem(id);
            }
            return this.itemMgr.getNode(id, parentId);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(relPath);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(relPath);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        this.sanityCheck();
        try {
            return this.itemMgr.getChildNodes((NodeId)this.id);
        }
        catch (ItemNotFoundException infe) {
            String msg = "failed to list the child nodes of " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        catch (AccessDeniedException ade) {
            String msg = "failed to list the child nodes of " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ade);
        }
    }

    public PropertyIterator getProperties() throws RepositoryException {
        this.sanityCheck();
        try {
            return this.itemMgr.getChildProperties((NodeId)this.id);
        }
        catch (ItemNotFoundException infe) {
            String msg = "failed to list the child properties of " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        catch (AccessDeniedException ade) {
            String msg = "failed to list the child properties of " + this;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ade);
        }
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        PropertyId id = this.resolveRelativePropertyPath(relPath);
        if (id == null) {
            throw new PathNotFoundException(relPath);
        }
        try {
            return (Property)this.itemMgr.getItem(id);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(relPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(relPath);
        }
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        this.sanityCheck();
        NodeId id = this.resolveRelativeNodePath(relPath);
        if (id != null) {
            return this.itemMgr.itemExists(id);
        }
        return false;
    }

    public boolean hasNodes() throws RepositoryException {
        this.sanityCheck();
        return this.itemMgr.hasChildNodes((NodeId)this.id);
    }

    public boolean hasProperties() throws RepositoryException {
        this.sanityCheck();
        return this.itemMgr.hasChildProperties((NodeId)this.id);
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        try {
            return this.isNodeType(this.session.getQName(nodeTypeName));
        }
        catch (NameException e) {
            throw new RepositoryException("invalid node type name: " + nodeTypeName, (Throwable)e);
        }
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        this.sanityCheck();
        return this.session.getNodeTypeManager().getNodeType(this.data.getNodeState().getNodeTypeName());
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.sanityCheck();
        Set<Name> mixinNames = this.data.getNodeState().getMixinTypeNames();
        if (mixinNames.isEmpty()) {
            return new NodeType[0];
        }
        NodeType[] nta = new NodeType[mixinNames.size()];
        Iterator<Name> iter = mixinNames.iterator();
        int i = 0;
        while (iter.hasNext()) {
            nta[i++] = this.session.getNodeTypeManager().getNodeType(iter.next());
        }
        return nta;
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            this.addMixin(this.session.getQName(mixinName));
        }
        catch (NameException e) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)e);
        }
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            this.removeMixin(this.session.getQName(mixinName));
        }
        catch (NameException e) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)e);
        }
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        Name ntName = this.session.getQName(mixinName);
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl mixin = ntMgr.getNodeType(ntName);
        if (!mixin.isMixin()) {
            return false;
        }
        int options = 150;
        int permissions = 128;
        if (NameConstants.MIX_VERSIONABLE.equals(ntName) || NameConstants.MIX_SIMPLE_VERSIONABLE.equals(ntName)) {
            permissions |= 0x100;
        }
        if (!this.session.getValidator().canModify(this, options, permissions)) {
            return false;
        }
        Name primaryTypeName = this.data.getNodeState().getNodeTypeName();
        NodeTypeImpl primaryType = ntMgr.getNodeType(primaryTypeName);
        if (primaryType.isDerivedFrom(ntName)) {
            return true;
        }
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            HashSet<Name> mixins = new HashSet<Name>(this.data.getNodeState().getMixinTypeNames());
            EffectiveNodeType entExisting = ntReg.getEffectiveNodeType(primaryTypeName, mixins);
            if (entExisting.includesNodeType(ntName)) {
                return true;
            }
            mixins.add(ntName);
            ntReg.getEffectiveNodeType(primaryTypeName, mixins);
        }
        catch (NodeTypeConflictException ntce) {
            return false;
        }
        return true;
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        this.sanityCheck();
        PropertyId id = this.resolveRelativePropertyPath(relPath);
        if (id != null) {
            return this.itemMgr.itemExists(id);
        }
        return false;
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return this.getReferences(null);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        this.sanityCheck();
        return this.data.getNodeDefinition();
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectChildNodes((Node)this, (String)namePattern);
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectProperties((Node)this, (String)namePattern);
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        String name = this.getPrimaryNodeType().getPrimaryItemName();
        if (name == null) {
            throw new ItemNotFoundException();
        }
        if (this.hasProperty(name)) {
            return this.getProperty(name);
        }
        if (this.hasNode(name)) {
            return this.getNode(name);
        }
        throw new ItemNotFoundException();
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        if (!this.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            throw new UnsupportedRepositoryOperationException();
        }
        return this.getNodeId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        SessionImpl srcSession = null;
        try {
            String relPath;
            srcSession = this.rep.createSession(this.session.getSubject(), workspaceName);
            NodeImpl m1 = this;
            while (m1.getDepth() != 0 && !m1.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
                m1 = (NodeImpl)m1.getParent();
            }
            if (m1.getDepth() == 0) {
                if (!srcSession.getItemManager().nodeExists(this.getPrimaryPath())) {
                    throw new ItemNotFoundException("Node not found: " + this);
                }
                String string = this.getPath();
                return string;
            }
            Node m2 = srcSession.getNodeByUUID(m1.getUUID());
            if (m1 == this) {
                String string = m2.getPath();
                return string;
            }
            try {
                Path p = m1.getPrimaryPath().computeRelativePath(this.getPrimaryPath());
                relPath = this.session.getJCRPath(p);
            }
            catch (NameException be) {
                String msg = "internal error: failed to determine relative path";
                log.error(msg, (Throwable)be);
                throw new RepositoryException(msg, (Throwable)be);
            }
            if (!m2.hasNode(relPath)) {
                throw new ItemNotFoundException();
            }
            String string = m2.getNode(relPath).getPath();
            return string;
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public int getIndex() throws RepositoryException {
        this.sanityCheck();
        NodeId parentId = this.getParentId();
        if (parentId == null) {
            return 1;
        }
        try {
            NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
            ChildNodeEntry parentEntry = parent.getChildNodeEntry(this.getNodeId());
            return parentEntry.getIndex();
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to determine index";
            log.error(msg, (Throwable)ise);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        this.sanityCheck();
        ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
        if (!this.isShareable()) {
            list.add(this);
        } else {
            NodeState state = this.data.getNodeState();
            for (NodeId parentId : state.getSharedSet()) {
                list.add(this.itemMgr.getNode(this.getNodeId(), parentId));
            }
        }
        return new NodeIteratorAdapter(list);
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        NodeIterator iter = this.getSharedSet();
        while (iter.hasNext()) {
            iter.nextNode().removeShare();
        }
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.remove();
    }

    boolean isShareable() {
        return this.data.getNodeState().isShareable();
    }

    public NodeId getParentId() {
        return this.data.getParentId();
    }

    boolean hasShareParent(NodeId parentId) {
        return this.data.getNodeState().containsShare(parentId);
    }

    void addShareParent(NodeId parentId) throws RepositoryException {
        if (!this.isShareable()) {
            String msg = this + " is not shareable.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeId srcId = this.getNodeId();
        HierarchyManager hierMgr = this.session.getHierarchyManager();
        if (parentId.equals(srcId) || hierMgr.isAncestor(srcId, parentId)) {
            String msg = "This would create a share cycle.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState state = this.data.getNodeState();
        if (!state.containsShare(parentId) && (state = (NodeState)this.getOrCreateTransientItemState()).addShare(parentId)) {
            return;
        }
        String msg = "Adding a shareable node twice to the same parent is not supported.";
        log.debug(msg);
        throw new UnsupportedRepositoryOperationException(msg);
    }

    @Override
    public Path getPrimaryPath() throws RepositoryException {
        if (!this.isShareable()) {
            return super.getPrimaryPath();
        }
        NodeId parentId = this.getParentId();
        NodeImpl parentNode = (NodeImpl)this.getParent();
        Path parentPath = parentNode.getPrimaryPath();
        PathBuilder builder = new PathBuilder(parentPath);
        ChildNodeEntry entry = parentNode.getNodeState().getChildNodeEntry(this.getNodeId());
        if (entry == null) {
            String msg = "failed to build path of " + this.id + ": " + parentId + " has no child entry for " + this.id;
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        if (entry.getIndex() == 1) {
            builder.addLast(entry.getName());
        } else {
            builder.addLast(entry.getName(), entry.getIndex());
        }
        return builder.getPath();
    }

    public boolean isCheckedOut() throws RepositoryException {
        this.sanityCheck();
        if (this.isNew()) {
            return true;
        }
        try {
            NodeState state = this.getNodeState();
            while (!state.hasPropertyName(NameConstants.JCR_ISCHECKEDOUT)) {
                NodeId parentId = state.getParentId();
                if (parentId == null) {
                    return true;
                }
                state = (NodeState)this.session.getItemStateManager().getItemState(parentId);
            }
            PropertyId id = new PropertyId(state.getNodeId(), NameConstants.JCR_ISCHECKEDOUT);
            PropertyState ps = (PropertyState)this.session.getItemStateManager().getItemState(id);
            return ps.getValues()[0].getBoolean();
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private VersionManagerImpl getVersionManagerImpl() {
        return this.session.getWorkspaceImpl().getVersionManagerImpl();
    }

    public void update(String srcWorkspaceName) throws RepositoryException {
        this.getVersionManagerImpl().update(this, srcWorkspaceName);
    }

    @Deprecated
    public Version checkin() throws RepositoryException {
        return this.getVersionManagerImpl().checkin(this.getPath());
    }

    @Deprecated
    public Version checkin(Calendar created) throws RepositoryException {
        return this.getVersionManagerImpl().checkin(this.getPath(), created);
    }

    @Deprecated
    public void checkout() throws RepositoryException {
        this.getVersionManagerImpl().checkout(this.getPath());
    }

    @Deprecated
    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws RepositoryException {
        return this.getVersionManagerImpl().merge(this.getPath(), srcWorkspace, bestEffort);
    }

    @Deprecated
    public void cancelMerge(Version version) throws RepositoryException {
        this.getVersionManagerImpl().cancelMerge(this.getPath(), version);
    }

    @Deprecated
    public void doneMerge(Version version) throws RepositoryException {
        this.getVersionManagerImpl().doneMerge(this.getPath(), version);
    }

    @Deprecated
    public void restore(String versionName, boolean removeExisting) throws RepositoryException {
        this.getVersionManagerImpl().restore(this.getPath(), versionName, removeExisting);
    }

    @Deprecated
    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        this.getVersionManagerImpl().restore(this, version, removeExisting);
    }

    @Deprecated
    public void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        if (this.hasNode(relPath)) {
            this.getVersionManagerImpl().restore((NodeImpl)this.getNode(relPath), version, removeExisting);
        } else {
            this.getVersionManagerImpl().restore(this.getPath() + "/" + relPath, version, removeExisting);
        }
    }

    @Deprecated
    public void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        this.getVersionManagerImpl().restoreByLabel(this.getPath(), versionLabel, removeExisting);
    }

    @Deprecated
    public VersionHistory getVersionHistory() throws RepositoryException {
        return this.getVersionManagerImpl().getVersionHistory(this.getPath());
    }

    @Deprecated
    public Version getBaseVersion() throws RepositoryException {
        return this.getVersionManagerImpl().getBaseVersion(this.getPath());
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.session.getWorkspace().getLockManager();
        return lockMgr.lock(this.getPath(), isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.session.getWorkspace().getLockManager();
        return lockMgr.getLock(this.getPath());
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.session.getWorkspace().getLockManager();
        lockMgr.unlock(this.getPath());
    }

    public boolean holdsLock() throws RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.session.getWorkspace().getLockManager();
        return lockMgr.holdsLock(this.getPath());
    }

    public boolean isLocked() throws RepositoryException {
        this.sanityCheck();
        LockManager lockMgr = this.session.getWorkspace().getLockManager();
        return lockMgr.isLocked(this.getPath());
    }

    protected void checkLock() throws LockException, RepositoryException {
        if (this.isNew()) {
            return;
        }
        this.session.getLockManager().checkLock(this);
    }

    public String getIdentifier() throws RepositoryException {
        return ((NodeId)this.id).toString();
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        this.sanityCheck();
        try {
            if (this.stateMgr.hasNodeReferences(this.getNodeId())) {
                NodeReferences refs = this.stateMgr.getNodeReferences(this.getNodeId());
                List<PropertyId> idList = refs.getReferences();
                if (name != null) {
                    Name qName;
                    try {
                        qName = this.session.getQName(name);
                    }
                    catch (NameException e) {
                        throw new RepositoryException("invalid property name: " + name, (Throwable)e);
                    }
                    ArrayList<PropertyId> filteredList = new ArrayList<PropertyId>(idList.size());
                    for (PropertyId propId : idList) {
                        if (!propId.getName().equals(qName)) continue;
                        filteredList.add(propId);
                    }
                    idList = filteredList;
                }
                return new LazyItemIterator(this.itemMgr, idList);
            }
            return PropertyIteratorAdapter.EMPTY;
        }
        catch (ItemStateException e) {
            String msg = "Unable to retrieve REFERENCE properties that refer to " + this.id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        this.sanityCheck();
        if (!this.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            return PropertyIteratorAdapter.EMPTY;
        }
        Value ref = this.getSession().getValueFactory().createValue((Node)this, true);
        ArrayList<Property> props = new ArrayList<Property>();
        QueryManagerImpl qm = (QueryManagerImpl)this.session.getWorkspace().getQueryManager();
        for (Node n : qm.getWeaklyReferringNodes(this)) {
            PropertyIterator it = n.getProperties();
            while (it.hasNext()) {
                Collection<Value> refs;
                Property p = it.nextProperty();
                if (p.getType() != 10 || !(refs = p.isMultiple() ? Arrays.asList(p.getValues()) : Collections.singleton(p.getValue())).contains(ref)) continue;
                props.add(p);
            }
        }
        return new PropertyIteratorAdapter(props);
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        if (name == null) {
            return this.getWeakReferences();
        }
        this.sanityCheck();
        if (!this.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            return PropertyIteratorAdapter.EMPTY;
        }
        try {
            StringBuilder stmt = new StringBuilder();
            stmt.append("//*[@").append(ISO9075.encode((String)name));
            stmt.append(" = '").append(this.data.getId()).append("']");
            Query q = this.session.getWorkspace().getQueryManager().createQuery(stmt.toString(), "xpath");
            QueryResult result = q.execute();
            ArrayList<Property> l = new ArrayList<Property>();
            NodeIterator nit = result.getNodes();
            while (nit.hasNext()) {
                Node n = nit.nextNode();
                l.add(n.getProperty(name));
            }
            if (l.isEmpty()) {
                return PropertyIteratorAdapter.EMPTY;
            }
            return new PropertyIteratorAdapter(l);
        }
        catch (RepositoryException e) {
            String msg = "Unable to retrieve WEAKREFERENCE properties that refer to " + this.id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectChildNodes((Node)this, (String[])nameGlobs);
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        this.sanityCheck();
        return ChildrenCollectorFilter.collectProperties((Node)this, (String[])nameGlobs);
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        PropertyIterator iter;
        QNodeDefinition nodeDef;
        EffectiveNodeType entAll;
        EffectiveNodeType entOld;
        EffectiveNodeType entNew;
        this.sanityCheck();
        int options = 150;
        this.session.getValidator().checkModify(this, options, 128);
        NodeState state = this.data.getNodeState();
        if (state.getParentId() == null) {
            String msg = "changing the primary type of the root node is not supported";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        Name ntName = this.session.getQName(nodeTypeName);
        if (ntName.equals(state.getNodeTypeName())) {
            log.debug("Node already has " + nodeTypeName + " as primary node type.");
            return;
        }
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl nt = ntMgr.getNodeType(ntName);
        if (nt.isMixin()) {
            throw new ConstraintViolationException(nodeTypeName + ": not a primary node type.");
        }
        if (nt.isAbstract()) {
            throw new ConstraintViolationException(nodeTypeName + ": is an abstract node type.");
        }
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            entNew = ntReg.getEffectiveNodeType(ntName);
            entOld = ntReg.getEffectiveNodeType(state.getNodeTypeName());
            entAll = ntReg.getEffectiveNodeType(ntName, state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            throw new ConstraintViolationException(ntce.getMessage());
        }
        try {
            NodeImpl parent = (NodeImpl)this.getParent();
            nodeDef = parent.getApplicableChildNodeDefinition(this.getQName(), ntName).unwrap();
        }
        catch (RepositoryException re) {
            String msg = this + ": no applicable definition found in parent node's node type";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        if (!nodeDef.equals(this.itemMgr.getDefinition(state).unwrap())) {
            this.onRedefine(nodeDef);
        }
        HashSet<QItemDefinition> oldDefs = new HashSet<QItemDefinition>(Arrays.asList(entOld.getAllItemDefs()));
        HashSet<QItemDefinition> newDefs = new HashSet<QItemDefinition>(Arrays.asList(entNew.getAllItemDefs()));
        HashSet<QItemDefinition> allDefs = new HashSet<QItemDefinition>(Arrays.asList(entAll.getAllItemDefs()));
        HashSet<QItemDefinition> addedDefs = new HashSet<QItemDefinition>(newDefs);
        addedDefs.removeAll(oldDefs);
        boolean referenceableOld = entOld.includesNodeType(NameConstants.MIX_REFERENCEABLE);
        boolean referenceableNew = entNew.includesNodeType(NameConstants.MIX_REFERENCEABLE);
        if (referenceableOld && !referenceableNew && (iter = this.getReferences()).hasNext()) {
            throw new ConstraintViolationException("the new primary type cannot be set as it would render this node 'non-referenceable' while it is still being referenced through at least one property of type REFERENCE");
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setNodeTypeName(ntName);
        this.internalSetProperty(NameConstants.JCR_PRIMARYTYPE, InternalValue.create(ntName));
        HashSet<Name> set = new HashSet<Name>(thisState.getPropertyNames());
        for (Name propName : set) {
            try {
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(new PropertyId(thisState.getNodeId(), propName));
                if (allDefs.contains(this.itemMgr.getDefinition(propState).unwrap())) continue;
                try {
                    PropertyImpl prop = (PropertyImpl)this.itemMgr.getItem(propState.getId());
                    if (prop.getDefinition().isProtected()) {
                        this.removeChildProperty(propName);
                        continue;
                    }
                    PropertyDefinitionImpl pdi = this.getApplicablePropertyDefinition(propName, propState.getType(), propState.isMultiValued(), false);
                    if (pdi.getRequiredType() != 0 && pdi.getRequiredType() != propState.getType()) {
                        if (propState.isMultiValued()) {
                            Value[] values = ValueHelper.convert((Value[])prop.getValues(), (int)pdi.getRequiredType(), (ValueFactory)this.session.getValueFactory());
                            prop.onRedefine(pdi.unwrap());
                            prop.setValue(values);
                        } else {
                            Value value = ValueHelper.convert((Value)prop.getValue(), (int)pdi.getRequiredType(), (ValueFactory)this.session.getValueFactory());
                            prop.onRedefine(pdi.unwrap());
                            prop.setValue(value);
                        }
                    } else {
                        prop.onRedefine(pdi.unwrap());
                    }
                    addedDefs.remove(pdi.unwrap());
                }
                catch (ValueFormatException vfe) {
                    this.removeChildProperty(propName);
                }
                catch (ConstraintViolationException cve) {
                    this.removeChildProperty(propName);
                }
            }
            catch (ItemStateException ise) {
                String msg = propName + ": failed to retrieve property state";
                log.error(msg, (Throwable)ise);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(thisState.getChildNodeEntries());
        for (int i = list.size() - 1; i >= 0; --i) {
            ChildNodeEntry entry = list.get(i);
            try {
                NodeState nodeState = (NodeState)this.stateMgr.getItemState(entry.getId());
                if (allDefs.contains(this.itemMgr.getDefinition(nodeState).unwrap())) continue;
                try {
                    NodeImpl node = (NodeImpl)this.itemMgr.getItem(nodeState.getId());
                    if (node.getDefinition().isProtected()) {
                        this.removeChildNode(entry.getId());
                        continue;
                    }
                    NodeDefinitionImpl ndi = this.getApplicableChildNodeDefinition(entry.getName(), nodeState.getNodeTypeName());
                    node.onRedefine(ndi.unwrap());
                    addedDefs.remove(ndi.unwrap());
                }
                catch (ConstraintViolationException cve) {
                    this.removeChildNode(entry.getId());
                }
                continue;
            }
            catch (ItemStateException ise) {
                String msg = entry.getName() + ": failed to retrieve node state";
                log.error(msg, (Throwable)ise);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        for (QItemDefinition def : addedDefs) {
            if (!def.isAutoCreated()) continue;
            if (def.definesNode()) {
                NodeDefinitionImpl ndi = ntMgr.getNodeDefinition((QNodeDefinition)def);
                this.createChildNode(def.getName(), (NodeTypeImpl)ndi.getDefaultPrimaryType(), null);
                continue;
            }
            PropertyDefinitionImpl pdi = ntMgr.getPropertyDefinition((QPropertyDefinition)def);
            this.createChildProperty(pdi.unwrap().getName(), pdi.getRequiredType(), pdi);
        }
    }

    public Property setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.session.getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            v = this.session.getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.isNodeType(NameConstants.MIX_LIFECYCLE)) {
            Node policy = this.getProperty(NameConstants.JCR_LIFECYCLE_POLICY).getNode();
            String state = this.getProperty(NameConstants.JCR_CURRENT_LIFECYCLE_STATE).getString();
            ArrayList<String> targetStates = new ArrayList<String>();
            if (policy.hasNode("transitions")) {
                Node transitions = policy.getNode("transitions");
                for (Node transition : JcrUtils.getChildNodes((Node)transitions)) {
                    String from = transition.getProperty("from").getString();
                    if (!from.equals(state)) continue;
                    String to = transition.getProperty("to").getString();
                    targetStates.add(to);
                }
            }
            return targetStates.toArray(new String[targetStates.size()]);
        }
        throw new UnsupportedRepositoryOperationException("Only nodes with mixin node type mix:lifecycle may participate in a lifecycle: " + this);
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        for (String target : this.getAllowedLifecycleTransistions()) {
            if (!target.equals(transition)) continue;
            PropertyImpl property = this.getProperty(NameConstants.JCR_CURRENT_LIFECYCLE_STATE);
            property.internalSetValue(new InternalValue[]{InternalValue.create(target)}, 1);
            property.save();
            return;
        }
        throw new InvalidLifecycleTransitionException("Invalid lifecycle transition \"" + transition + "\" for " + this);
    }

    public void assignLifecyclePolicy(Node policy, String state) throws RepositoryException {
        if (!(policy instanceof NodeImpl) || !((NodeImpl)policy).isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            throw new RepositoryException(policy + " is not referenceable, so it can not be" + " used as a lifecycle policy");
        }
        this.addMixin(NameConstants.MIX_LIFECYCLE);
        this.internalSetProperty(NameConstants.JCR_LIFECYCLE_POLICY, InternalValue.create(((NodeImpl)policy).getNodeId()));
        this.internalSetProperty(NameConstants.JCR_CURRENT_LIFECYCLE_STATE, InternalValue.create(state));
    }

    @Override
    public String toString() {
        return "node " + super.toString();
    }
}

