/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.filters;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.filters.BasicPageFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ProfanityFilter
extends BasicPageFilter {
    private static Logger log = Logger.getLogger(ProfanityFilter.class);
    private static final String PROPERTYFILE = "com/ecyrd/jspwiki/filters/profanity.properties";
    private static String[] c_profanities = new String[0];

    public String preTranslate(WikiContext context, String content) {
        for (int i = 0; i < c_profanities.length; ++i) {
            String word = c_profanities[i];
            String replacement = word.charAt(0) + "*" + word.charAt(word.length() - 1);
            content = TextUtil.replaceStringCaseUnsensitive(content, word, replacement);
        }
        return content;
    }

    static {
        try {
            String str;
            ClassLoader loader = ProfanityFilter.class.getClassLoader();
            InputStream in = loader.getResourceAsStream(PROPERTYFILE);
            if (in == null) {
                throw new IOException("No property file found! (Check the installation, it should be there.)");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> profs = new ArrayList<String>();
            while ((str = br.readLine()) != null) {
                if (str.length() <= 0 || str.startsWith("#")) continue;
                profs.add(str);
            }
            c_profanities = profs.toArray(new String[0]);
        }
        catch (IOException e) {
            log.error((Object)"Unable to load profanities from com/ecyrd/jspwiki/filters/profanity.properties", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unable to initialize Profanity Filter", (Throwable)e);
        }
    }
}

