/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.notifications.model.impl;

import com.liferay.notifications.model.UserNotificationEvent;
import com.liferay.notifications.model.UserNotificationEventModel;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import java.io.Serializable;

import java.sql.Types;

import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the UserNotificationEvent service. Represents a row in the &quot;Notifications_UserNotificationEvent&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link com.liferay.notifications.model.UserNotificationEventModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserNotificationEventImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserNotificationEventImpl
 * @see com.liferay.notifications.model.UserNotificationEvent
 * @see com.liferay.notifications.model.UserNotificationEventModel
 * @generated
 */
public class UserNotificationEventModelImpl extends BaseModelImpl<UserNotificationEvent>
	implements UserNotificationEventModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user notification event model instance should use the {@link com.liferay.notifications.model.UserNotificationEvent} interface instead.
	 */
	public static final String TABLE_NAME = "Notifications_UserNotificationEvent";
	public static final Object[][] TABLE_COLUMNS = {
			{ "notificationEventId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userNotificationEventId", Types.BIGINT },
			{ "timestamp", Types.BIGINT },
			{ "delivered", Types.BOOLEAN },
			{ "actionRequired", Types.BOOLEAN },
			{ "archived", Types.BOOLEAN }
		};
	public static final String TABLE_SQL_CREATE = "create table Notifications_UserNotificationEvent (notificationEventId LONG not null primary key,companyId LONG,userId LONG,userNotificationEventId LONG,timestamp LONG,delivered BOOLEAN,actionRequired BOOLEAN,archived BOOLEAN)";
	public static final String TABLE_SQL_DROP = "drop table Notifications_UserNotificationEvent";
	public static final String ORDER_BY_JPQL = " ORDER BY userNotificationEvent.timestamp DESC";
	public static final String ORDER_BY_SQL = " ORDER BY Notifications_UserNotificationEvent.timestamp DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.notifications.model.UserNotificationEvent"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.notifications.model.UserNotificationEvent"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.notifications.model.UserNotificationEvent"),
			true);
	public static long ACTIONREQUIRED_COLUMN_BITMASK = 1L;
	public static long ARCHIVED_COLUMN_BITMASK = 2L;
	public static long DELIVERED_COLUMN_BITMASK = 4L;
	public static long USERID_COLUMN_BITMASK = 8L;
	public static long USERNOTIFICATIONEVENTID_COLUMN_BITMASK = 16L;
	public static long TIMESTAMP_COLUMN_BITMASK = 32L;
	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
				"lock.expiration.time.com.liferay.notifications.model.UserNotificationEvent"));

	public UserNotificationEventModelImpl() {
	}


	public long getPrimaryKey() {
		return _notificationEventId;
	}


	public void setPrimaryKey(long primaryKey) {
		setNotificationEventId(primaryKey);
	}


	public Serializable getPrimaryKeyObj() {
		return _notificationEventId;
	}


	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}


	public Class<?> getModelClass() {
		return UserNotificationEvent.class;
	}


	public String getModelClassName() {
		return UserNotificationEvent.class.getName();
	}


	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("notificationEventId", getNotificationEventId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userNotificationEventId", getUserNotificationEventId());
		attributes.put("timestamp", getTimestamp());
		attributes.put("delivered", getDelivered());
		attributes.put("actionRequired", getActionRequired());
		attributes.put("archived", getArchived());

		return attributes;
	}


	public void setModelAttributes(Map<String, Object> attributes) {
		Long notificationEventId = (Long)attributes.get("notificationEventId");

		if (notificationEventId != null) {
			setNotificationEventId(notificationEventId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		Long userNotificationEventId = (Long)attributes.get(
				"userNotificationEventId");

		if (userNotificationEventId != null) {
			setUserNotificationEventId(userNotificationEventId);
		}

		Long timestamp = (Long)attributes.get("timestamp");

		if (timestamp != null) {
			setTimestamp(timestamp);
		}

		Boolean delivered = (Boolean)attributes.get("delivered");

		if (delivered != null) {
			setDelivered(delivered);
		}

		Boolean actionRequired = (Boolean)attributes.get("actionRequired");

		if (actionRequired != null) {
			setActionRequired(actionRequired);
		}

		Boolean archived = (Boolean)attributes.get("archived");

		if (archived != null) {
			setArchived(archived);
		}
	}


	public long getNotificationEventId() {
		return _notificationEventId;
	}


	public void setNotificationEventId(long notificationEventId) {
		_notificationEventId = notificationEventId;
	}


	public long getCompanyId() {
		return _companyId;
	}


	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}


	public long getUserId() {
		return _userId;
	}


	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}


	public String getUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
	}


	public void setUserUuid(String userUuid) {
		_userUuid = userUuid;
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}


	public long getUserNotificationEventId() {
		return _userNotificationEventId;
	}


	public void setUserNotificationEventId(long userNotificationEventId) {
		_columnBitmask |= USERNOTIFICATIONEVENTID_COLUMN_BITMASK;

		if (!_setOriginalUserNotificationEventId) {
			_setOriginalUserNotificationEventId = true;

			_originalUserNotificationEventId = _userNotificationEventId;
		}

		_userNotificationEventId = userNotificationEventId;
	}

	public long getOriginalUserNotificationEventId() {
		return _originalUserNotificationEventId;
	}


	public long getTimestamp() {
		return _timestamp;
	}


	public void setTimestamp(long timestamp) {
		_columnBitmask = -1L;

		_timestamp = timestamp;
	}


	public boolean getDelivered() {
		return _delivered;
	}


	public boolean isDelivered() {
		return _delivered;
	}


	public void setDelivered(boolean delivered) {
		_columnBitmask |= DELIVERED_COLUMN_BITMASK;

		if (!_setOriginalDelivered) {
			_setOriginalDelivered = true;

			_originalDelivered = _delivered;
		}

		_delivered = delivered;
	}

	public boolean getOriginalDelivered() {
		return _originalDelivered;
	}


	public boolean getActionRequired() {
		return _actionRequired;
	}


	public boolean isActionRequired() {
		return _actionRequired;
	}


	public void setActionRequired(boolean actionRequired) {
		_columnBitmask |= ACTIONREQUIRED_COLUMN_BITMASK;

		if (!_setOriginalActionRequired) {
			_setOriginalActionRequired = true;

			_originalActionRequired = _actionRequired;
		}

		_actionRequired = actionRequired;
	}

	public boolean getOriginalActionRequired() {
		return _originalActionRequired;
	}


	public boolean getArchived() {
		return _archived;
	}


	public boolean isArchived() {
		return _archived;
	}


	public void setArchived(boolean archived) {
		_columnBitmask |= ARCHIVED_COLUMN_BITMASK;

		if (!_setOriginalArchived) {
			_setOriginalArchived = true;

			_originalArchived = _archived;
		}

		_archived = archived;
	}

	public boolean getOriginalArchived() {
		return _originalArchived;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}


	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			UserNotificationEvent.class.getName(), getPrimaryKey());
	}


	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}


	public UserNotificationEvent toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (UserNotificationEvent)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}


	public Object clone() {
		UserNotificationEventImpl userNotificationEventImpl = new UserNotificationEventImpl();

		userNotificationEventImpl.setNotificationEventId(getNotificationEventId());
		userNotificationEventImpl.setCompanyId(getCompanyId());
		userNotificationEventImpl.setUserId(getUserId());
		userNotificationEventImpl.setUserNotificationEventId(getUserNotificationEventId());
		userNotificationEventImpl.setTimestamp(getTimestamp());
		userNotificationEventImpl.setDelivered(getDelivered());
		userNotificationEventImpl.setActionRequired(getActionRequired());
		userNotificationEventImpl.setArchived(getArchived());

		userNotificationEventImpl.resetOriginalValues();

		return userNotificationEventImpl;
	}


	public int compareTo(UserNotificationEvent userNotificationEvent) {
		int value = 0;

		if (getTimestamp() < userNotificationEvent.getTimestamp()) {
			value = -1;
		}
		else if (getTimestamp() > userNotificationEvent.getTimestamp()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}


	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof UserNotificationEvent)) {
			return false;
		}

		UserNotificationEvent userNotificationEvent = (UserNotificationEvent)obj;

		long primaryKey = userNotificationEvent.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}


	public int hashCode() {
		return (int)getPrimaryKey();
	}


	public void resetOriginalValues() {
		UserNotificationEventModelImpl userNotificationEventModelImpl = this;

		userNotificationEventModelImpl._originalUserId = userNotificationEventModelImpl._userId;

		userNotificationEventModelImpl._setOriginalUserId = false;

		userNotificationEventModelImpl._originalUserNotificationEventId = userNotificationEventModelImpl._userNotificationEventId;

		userNotificationEventModelImpl._setOriginalUserNotificationEventId = false;

		userNotificationEventModelImpl._originalDelivered = userNotificationEventModelImpl._delivered;

		userNotificationEventModelImpl._setOriginalDelivered = false;

		userNotificationEventModelImpl._originalActionRequired = userNotificationEventModelImpl._actionRequired;

		userNotificationEventModelImpl._setOriginalActionRequired = false;

		userNotificationEventModelImpl._originalArchived = userNotificationEventModelImpl._archived;

		userNotificationEventModelImpl._setOriginalArchived = false;

		userNotificationEventModelImpl._columnBitmask = 0;
	}


	public CacheModel<UserNotificationEvent> toCacheModel() {
		UserNotificationEventCacheModel userNotificationEventCacheModel = new UserNotificationEventCacheModel();

		userNotificationEventCacheModel.notificationEventId = getNotificationEventId();

		userNotificationEventCacheModel.companyId = getCompanyId();

		userNotificationEventCacheModel.userId = getUserId();

		userNotificationEventCacheModel.userNotificationEventId = getUserNotificationEventId();

		userNotificationEventCacheModel.timestamp = getTimestamp();

		userNotificationEventCacheModel.delivered = getDelivered();

		userNotificationEventCacheModel.actionRequired = getActionRequired();

		userNotificationEventCacheModel.archived = getArchived();

		return userNotificationEventCacheModel;
	}


	public String toString() {
		StringBundler sb = new StringBundler(17);

		sb.append("{notificationEventId=");
		sb.append(getNotificationEventId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userNotificationEventId=");
		sb.append(getUserNotificationEventId());
		sb.append(", timestamp=");
		sb.append(getTimestamp());
		sb.append(", delivered=");
		sb.append(getDelivered());
		sb.append(", actionRequired=");
		sb.append(getActionRequired());
		sb.append(", archived=");
		sb.append(getArchived());
		sb.append("}");

		return sb.toString();
	}


	public String toXmlString() {
		StringBundler sb = new StringBundler(28);

		sb.append("<model><model-name>");
		sb.append("com.liferay.notifications.model.UserNotificationEvent");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>notificationEventId</column-name><column-value><![CDATA[");
		sb.append(getNotificationEventId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userNotificationEventId</column-name><column-value><![CDATA[");
		sb.append(getUserNotificationEventId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>timestamp</column-name><column-value><![CDATA[");
		sb.append(getTimestamp());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>delivered</column-name><column-value><![CDATA[");
		sb.append(getDelivered());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>actionRequired</column-name><column-value><![CDATA[");
		sb.append(getActionRequired());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>archived</column-name><column-value><![CDATA[");
		sb.append(getArchived());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static ClassLoader _classLoader = UserNotificationEvent.class.getClassLoader();
	private static Class<?>[] _escapedModelInterfaces = new Class[] {
			UserNotificationEvent.class
		};
	private long _notificationEventId;
	private long _companyId;
	private long _userId;
	private String _userUuid;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private long _userNotificationEventId;
	private long _originalUserNotificationEventId;
	private boolean _setOriginalUserNotificationEventId;
	private long _timestamp;
	private boolean _delivered;
	private boolean _originalDelivered;
	private boolean _setOriginalDelivered;
	private boolean _actionRequired;
	private boolean _originalActionRequired;
	private boolean _setOriginalActionRequired;
	private boolean _archived;
	private boolean _originalArchived;
	private boolean _setOriginalArchived;
	private long _columnBitmask;
	private UserNotificationEvent _escapedModel;
}