/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.Map;

public class PortalBeanLocatorUtil {
    private static Log _log = LogFactoryUtil.getLog(PortalBeanLocatorUtil.class);
    private static BeanLocator _beanLocator;
    private static PACL _pacl;

    static {
        _pacl = new NoPACL();
    }

    public static BeanLocator getBeanLocator() {
        PortalRuntimePermission.checkGetBeanProperty(PortalBeanLocatorUtil.class);
        return _beanLocator;
    }

    public static <T> Map<String, T> locate(Class<T> clazz) {
        BeanLocator beanLocator = PortalBeanLocatorUtil.getBeanLocator();
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            throw new BeanLocatorException("BeanLocator has not been set");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = _pacl.getContextClassLoader(currentThread);
        ClassLoader beanClassLoader = _pacl.getBeanLocatorClassLoader(beanLocator);
        try {
            if (contextClassLoader != beanClassLoader) {
                _pacl.setContextClassLoader(currentThread, beanClassLoader);
            }
            Map<String, T> map = beanLocator.locate(clazz);
            return map;
        }
        finally {
            if (contextClassLoader != beanClassLoader) {
                _pacl.setContextClassLoader(currentThread, contextClassLoader);
            }
        }
    }

    public static Object locate(String name) throws BeanLocatorException {
        BeanLocator beanLocator = PortalBeanLocatorUtil.getBeanLocator();
        if (beanLocator == null) {
            _log.error("BeanLocator is null");
            Thread.dumpStack();
            if (_log.isDebugEnabled()) {
                Exception e = new Exception();
                _log.debug(e, e);
            }
            throw new BeanLocatorException("BeanLocator has not been set");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = _pacl.getContextClassLoader(currentThread);
        ClassLoader beanClassLoader = _pacl.getBeanLocatorClassLoader(beanLocator);
        try {
            if (contextClassLoader != beanClassLoader) {
                _pacl.setContextClassLoader(currentThread, beanClassLoader);
            }
            Object object = beanLocator.locate(name);
            return object;
        }
        finally {
            if (contextClassLoader != beanClassLoader) {
                _pacl.setContextClassLoader(currentThread, contextClassLoader);
            }
        }
    }

    public static void reset() {
        PortalBeanLocatorUtil.setBeanLocator(null);
    }

    public static void setBeanLocator(BeanLocator beanLocator) {
        PortalRuntimePermission.checkSetBeanProperty(PortalBeanLocatorUtil.class);
        if (_log.isDebugEnabled()) {
            if (beanLocator == null) {
                _log.debug("Setting BeanLocator " + beanLocator);
            } else {
                _log.debug("Setting BeanLocator " + beanLocator.hashCode());
            }
        }
        _beanLocator = beanLocator;
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public ClassLoader getBeanLocatorClassLoader(BeanLocator beanLocator) {
            return beanLocator.getClassLoader();
        }

        @Override
        public ClassLoader getContextClassLoader(Thread currentThread) {
            return currentThread.getContextClassLoader();
        }

        @Override
        public void setContextClassLoader(Thread currentThread, ClassLoader classLoader) {
            currentThread.setContextClassLoader(classLoader);
        }
    }

    public static interface PACL {
        public ClassLoader getBeanLocatorClassLoader(BeanLocator var1);

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);
    }
}

