/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor;
import org.aspectj.weaver.loadtime.ClassPreProcessor;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingAdaptor;

public class Aj
implements ClassPreProcessor {
    private IWeavingContext weavingContext;
    private static ReferenceQueue adaptorQueue = new ReferenceQueue();
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(Aj.class);
    private static final String deleLoader = "sun.reflect.DelegatingClassLoader";

    public Aj() {
        this(null);
    }

    public Aj(IWeavingContext context) {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", (Object)this, new Object[]{context, this.getClass().getClassLoader()});
        }
        this.weavingContext = context;
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] preProcess(String className, byte[] bytes, ClassLoader loader, ProtectionDomain protectionDomain) {
        if (loader == null) return bytes;
        if (className == null) return bytes;
        if (loader.getClass().getName().equals("sun.reflect.DelegatingClassLoader")) {
            return bytes;
        }
        if (Aj.trace.isTraceEnabled()) {
            Aj.trace.enter("preProcess", (Object)this, new Object[]{className, bytes, loader});
        }
        if (Aj.trace.isTraceEnabled()) {
            Aj.trace.event("preProcess", (Object)this, new Object[]{loader.getParent(), Thread.currentThread().getContextClassLoader()});
        }
        var5_5 = loader;
        synchronized (var5_5) {
            weavingAdaptor = WeaverContainer.getWeaver(loader, this.weavingContext);
            if (weavingAdaptor == null) {
                if (Aj.trace.isTraceEnabled()) {
                    Aj.trace.exit("preProcess");
                }
                var7_8 = bytes;
            }
            ** GOTO lbl-1000
        }
        {
            catch (Throwable th) {
                Aj.trace.error(className, th);
                Dump.dumpWithException(th);
                if (Aj.trace.isTraceEnabled() == false) return bytes;
                Aj.trace.exit("preProcess", th);
                return bytes;
            }
            catch (Throwable var11_12) {
                throw var11_12;
            }
            CompilationAndWeavingContext.resetForThread();
            return var7_8;
lbl-1000:
            // 1 sources

            {
                try {
                    weavingAdaptor.setActiveProtectionDomain(protectionDomain);
                    newBytes = weavingAdaptor.weaveClass(className, bytes, false);
                    Dump.dumpOnExit(weavingAdaptor.getMessageHolder(), true);
                    if (Aj.trace.isTraceEnabled()) {
                        Aj.trace.exit("preProcess", newBytes);
                    }
                    var8_10 = newBytes;
                    weavingAdaptor.setActiveProtectionDomain(null);
                }
                catch (Throwable var9_11) {}
                {
                    weavingAdaptor.setActiveProtectionDomain(null);
                    throw var9_11;
                }
            }
        }
        CompilationAndWeavingContext.resetForThread();
        return var8_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeStaleAdaptors(boolean displayProgress) {
        int removed = 0;
        Map map = WeaverContainer.weavingAdaptors;
        synchronized (map) {
            if (displayProgress) {
                System.err.println("Weaver adaptors before queue processing:");
                Map m = WeaverContainer.weavingAdaptors;
                Set keys = m.keySet();
                for (Object object : keys) {
                    System.err.println(object + " = " + WeaverContainer.weavingAdaptors.get(object));
                }
            }
            Reference o = adaptorQueue.poll();
            while (o != null) {
                AdaptorKey wo;
                boolean didit;
                if (displayProgress) {
                    System.err.println("Processing referencequeue entry " + o);
                }
                boolean bl = didit = WeaverContainer.weavingAdaptors.remove(wo = (AdaptorKey)o) != null;
                if (didit) {
                    ++removed;
                } else {
                    throw new RuntimeException("Eh?? key=" + wo);
                }
                if (displayProgress) {
                    System.err.println("Removed? " + didit);
                }
                o = adaptorQueue.poll();
            }
            if (displayProgress) {
                System.err.println("Weaver adaptors after queue processing:");
                Map m = WeaverContainer.weavingAdaptors;
                Set keys = m.keySet();
                for (Object object : keys) {
                    System.err.println(object + " = " + WeaverContainer.weavingAdaptors.get(object));
                }
            }
        }
        return removed;
    }

    public static int getActiveAdaptorCount() {
        return WeaverContainer.weavingAdaptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkQ() {
        ReferenceQueue referenceQueue = adaptorQueue;
        synchronized (referenceQueue) {
            Reference o = adaptorQueue.poll();
            while (o != null) {
                AdaptorKey wo = (AdaptorKey)o;
                WeaverContainer.weavingAdaptors.remove(wo);
                o = adaptorQueue.poll();
            }
        }
    }

    public String getNamespace(ClassLoader loader) {
        ClassLoaderWeavingAdaptor weavingAdaptor = (ClassLoaderWeavingAdaptor)WeaverContainer.getWeaver(loader, this.weavingContext);
        return weavingAdaptor.getNamespace();
    }

    public boolean generatedClassesExist(ClassLoader loader) {
        return ((ClassLoaderWeavingAdaptor)WeaverContainer.getWeaver(loader, this.weavingContext)).generatedClassesExistFor(null);
    }

    public void flushGeneratedClasses(ClassLoader loader) {
        ((ClassLoaderWeavingAdaptor)WeaverContainer.getWeaver(loader, this.weavingContext)).flushGeneratedClasses();
    }

    static {
        new ExplicitlyInitializedClassLoaderWeavingAdaptor(new ClassLoaderWeavingAdaptor());
    }

    static class ExplicitlyInitializedClassLoaderWeavingAdaptor {
        private final ClassLoaderWeavingAdaptor weavingAdaptor;
        private boolean isInitialized;

        public ExplicitlyInitializedClassLoaderWeavingAdaptor(ClassLoaderWeavingAdaptor weavingAdaptor) {
            this.weavingAdaptor = weavingAdaptor;
            this.isInitialized = false;
        }

        private void initialize(ClassLoader loader, IWeavingContext weavingContext) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.weavingAdaptor.initialize(loader, weavingContext);
            }
        }

        public ClassLoaderWeavingAdaptor getWeavingAdaptor(ClassLoader loader, IWeavingContext weavingContext) {
            this.initialize(loader, weavingContext);
            return this.weavingAdaptor;
        }
    }

    static class WeaverContainer {
        static final Map weavingAdaptors = Collections.synchronizedMap(new HashMap());

        WeaverContainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static WeavingAdaptor getWeaver(ClassLoader loader, IWeavingContext weavingContext) {
            ExplicitlyInitializedClassLoaderWeavingAdaptor adaptor = null;
            AdaptorKey adaptorKey = new AdaptorKey(loader);
            String loaderClassName = loader.getClass().getName();
            Map map = weavingAdaptors;
            synchronized (map) {
                Aj.checkQ();
                adaptor = (ExplicitlyInitializedClassLoaderWeavingAdaptor)weavingAdaptors.get(adaptorKey);
                if (adaptor == null) {
                    ClassLoaderWeavingAdaptor weavingAdaptor = new ClassLoaderWeavingAdaptor();
                    adaptor = new ExplicitlyInitializedClassLoaderWeavingAdaptor(weavingAdaptor);
                    weavingAdaptors.put(adaptorKey, adaptor);
                }
            }
            return adaptor.getWeavingAdaptor(loader, weavingContext);
        }
    }

    private static class AdaptorKey
    extends WeakReference {
        private int hashcode = -1;

        public AdaptorKey(ClassLoader loader) {
            super(loader, adaptorQueue);
            this.hashcode = loader.hashCode() * 37;
        }

        public ClassLoader getClassLoader() {
            ClassLoader instance = (ClassLoader)this.get();
            return instance;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AdaptorKey)) {
                return false;
            }
            AdaptorKey other = (AdaptorKey)obj;
            return other.hashcode == this.hashcode;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

