/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Shard;
import com.liferay.portal.service.base.ShardLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;

public class ShardLocalServiceImpl
extends ShardLocalServiceBaseImpl {
    public Shard addShard(String className, long classPK, String name) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        if (Validator.isNull((String)name)) {
            name = PropsValues.SHARD_DEFAULT_NAME;
        }
        long shardId = this.counterLocalService.increment();
        Shard shard = this.shardPersistence.create(shardId);
        shard.setClassNameId(classNameId);
        shard.setClassPK(classPK);
        shard.setName(name);
        this.shardPersistence.update((BaseModel)shard);
        return shard;
    }

    public Shard getShard(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.shardPersistence.findByC_C(classNameId, classPK);
    }
}

