/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchLayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutFriendlyURLLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutFriendlyURLLocalServiceImpl
extends LayoutFriendlyURLLocalServiceBaseImpl {
    public LayoutFriendlyURL addLayoutFriendlyURL(long userId, long companyId, long groupId, long plid, boolean privateLayout, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long layoutFriendlyURLId = this.counterLocalService.increment();
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.create(layoutFriendlyURLId);
        layoutFriendlyURL.setUuid(serviceContext.getUuid());
        layoutFriendlyURL.setGroupId(groupId);
        layoutFriendlyURL.setCompanyId(companyId);
        layoutFriendlyURL.setUserId(user.getUserId());
        layoutFriendlyURL.setUserName(user.getFullName());
        layoutFriendlyURL.setCreateDate(serviceContext.getCreateDate(now));
        layoutFriendlyURL.setModifiedDate(serviceContext.getModifiedDate(now));
        layoutFriendlyURL.setPlid(plid);
        layoutFriendlyURL.setPrivateLayout(privateLayout);
        layoutFriendlyURL.setFriendlyURL(friendlyURL);
        layoutFriendlyURL.setLanguageId(languageId);
        return (LayoutFriendlyURL)this.layoutFriendlyURLPersistence.update((BaseModel)layoutFriendlyURL);
    }

    public List<LayoutFriendlyURL> addLayoutFriendlyURLs(long userId, long companyId, long groupId, long plid, boolean privateLayout, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException, SystemException {
        Locale[] locales;
        ArrayList<LayoutFriendlyURL> layoutFriendlyURLs = new ArrayList<LayoutFriendlyURL>();
        Locale[] localeArray = locales = LanguageUtil.getAvailableLocales((long)groupId);
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String friendlyURL = friendlyURLMap.get(locale);
            if (!Validator.isNull((String)friendlyURL)) {
                LayoutFriendlyURL layoutFriendlyURL = this.addLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, LocaleUtil.toLanguageId((Locale)locale), serviceContext);
                layoutFriendlyURLs.add(layoutFriendlyURL);
            }
            ++n2;
        }
        return layoutFriendlyURLs;
    }

    @Override
    public LayoutFriendlyURL deleteLayoutFriendlyURL(LayoutFriendlyURL layoutFriendlyURL) throws SystemException {
        return (LayoutFriendlyURL)this.layoutFriendlyURLPersistence.remove((BaseModel)layoutFriendlyURL);
    }

    public void deleteLayoutFriendlyURL(long plid, String languageId) throws SystemException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL != null) {
            this.deleteLayoutFriendlyURL(layoutFriendlyURL);
        }
    }

    public void deleteLayoutFriendlyURLs(long plid) throws SystemException {
        List layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByPlid(plid);
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            this.deleteLayoutFriendlyURL(layoutFriendlyURL);
        }
    }

    public LayoutFriendlyURL fetchFirstLayoutFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) throws SystemException {
        return this.layoutFriendlyURLPersistence.fetchByG_P_F_First(groupId, privateLayout, friendlyURL, null);
    }

    public LayoutFriendlyURL fetchLayoutFriendlyURL(long groupId, boolean privateLayout, String friendlyURL, String languageId) throws SystemException {
        return this.layoutFriendlyURLPersistence.fetchByG_P_F_L(groupId, privateLayout, friendlyURL, languageId);
    }

    public LayoutFriendlyURL fetchLayoutFriendlyURL(long plid, String languageId) throws SystemException {
        return this.fetchLayoutFriendlyURL(plid, languageId, true);
    }

    public LayoutFriendlyURL fetchLayoutFriendlyURL(long plid, String languageId, boolean useDefault) throws SystemException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null && !useDefault) {
            return null;
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByPlid_First(plid, null);
        }
        return layoutFriendlyURL;
    }

    public LayoutFriendlyURL getLayoutFriendlyURL(long plid, String languageId) throws PortalException, SystemException {
        return this.getLayoutFriendlyURL(plid, languageId, true);
    }

    public LayoutFriendlyURL getLayoutFriendlyURL(long plid, String languageId, boolean useDefault) throws PortalException, SystemException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null && !useDefault) {
            StringBundler sb = new StringBundler(5);
            sb.append("{plid=");
            sb.append(plid);
            sb.append(", languageId=");
            sb.append(languageId);
            sb.append("}");
            throw new NoSuchLayoutFriendlyURLException(sb.toString());
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.findByPlid_First(plid, null);
        }
        return layoutFriendlyURL;
    }

    public List<LayoutFriendlyURL> getLayoutFriendlyURLs(long plid) throws SystemException {
        return this.layoutFriendlyURLPersistence.findByPlid(plid);
    }

    public List<LayoutFriendlyURL> getLayoutFriendlyURLs(long plid, String friendlyURL, int start, int end) throws SystemException {
        return this.layoutFriendlyURLPersistence.findByP_F(plid, friendlyURL, start, end);
    }

    public LayoutFriendlyURL updateLayoutFriendlyURL(long userId, long companyId, long groupId, long plid, boolean privateLayout, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null) {
            return this.addLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, languageId, serviceContext);
        }
        layoutFriendlyURL.setFriendlyURL(friendlyURL);
        return (LayoutFriendlyURL)this.layoutFriendlyURLPersistence.update((BaseModel)layoutFriendlyURL);
    }

    public List<LayoutFriendlyURL> updateLayoutFriendlyURLs(long userId, long companyId, long groupId, long plid, boolean privateLayout, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException, SystemException {
        Locale[] locales;
        ArrayList<LayoutFriendlyURL> layoutFriendlyURLs = new ArrayList<LayoutFriendlyURL>();
        Locale[] localeArray = locales = LanguageUtil.getAvailableLocales((long)groupId);
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String friendlyURL = friendlyURLMap.get(locale);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            if (Validator.isNull((String)friendlyURL)) {
                this.deleteLayoutFriendlyURL(plid, languageId);
            } else {
                LayoutFriendlyURL layoutFriendlyURL = this.updateLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, languageId, serviceContext);
                layoutFriendlyURLs.add(layoutFriendlyURL);
            }
            ++n2;
        }
        return layoutFriendlyURLs;
    }
}

