/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.Ordering;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class MultiColumnQueryAdapter
implements MultiColumnQuery {
    private final Query query;
    private final Name selectorName;

    private MultiColumnQueryAdapter(Query query, Name selectorName) {
        this.query = query;
        this.selectorName = selectorName;
    }

    public static MultiColumnQuery adapt(Query query, Name selectorName) {
        return new MultiColumnQueryAdapter(query, selectorName);
    }

    public MultiColumnQueryHits execute(JackrabbitIndexSearcher searcher, Ordering[] orderings, long resultFetchHint) throws IOException {
        SortField[] fields = new SortField[orderings.length];
        for (int i = 0; i < orderings.length; ++i) {
            fields[i] = orderings[i].getSortField();
        }
        return searcher.execute(this.query, new Sort(fields), resultFetchHint, this.selectorName);
    }
}

