/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Transaction;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.event.EventSource;

public class AuditProcessManager {
    private final Map<Transaction, AuditProcess> auditProcesses = new ConcurrentHashMap<Transaction, AuditProcess>();
    private final RevisionInfoGenerator revisionInfoGenerator;

    public AuditProcessManager(RevisionInfoGenerator revisionInfoGenerator) {
        this.revisionInfoGenerator = revisionInfoGenerator;
    }

    public AuditProcess get(EventSource session) {
        final Transaction transaction = session.getTransaction();
        AuditProcess auditProcess = this.auditProcesses.get(transaction);
        if (auditProcess == null) {
            auditProcess = new AuditProcess(this.revisionInfoGenerator, session);
            this.auditProcesses.put(transaction, auditProcess);
            session.getActionQueue().registerProcess(auditProcess);
            session.getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
                    AuditProcessManager.this.auditProcesses.remove(transaction);
                }
            });
        }
        return auditProcess;
    }
}

