/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientInfoGenerator;

class KeyAgreeRecipientInfoGenerator
implements RecipientInfoGenerator {
    private DERObjectIdentifier algorithmOID;
    private OriginatorIdentifierOrKey originator;
    private TBSCertificateStructure recipientTBSCert;
    private ASN1OctetString ukm;
    private DERObjectIdentifier wrapAlgorithmOID;
    private SecretKey wrapKey;

    KeyAgreeRecipientInfoGenerator() {
    }

    void setAlgorithmOID(DERObjectIdentifier dERObjectIdentifier) {
        this.algorithmOID = dERObjectIdentifier;
    }

    void setOriginator(OriginatorIdentifierOrKey originatorIdentifierOrKey) {
        this.originator = originatorIdentifierOrKey;
    }

    void setRecipientCert(X509Certificate x509Certificate) {
        try {
            this.recipientTBSCert = CMSUtils.getTBSCertificateStructure(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("can't extract TBS structure from this cert");
        }
    }

    void setUKM(ASN1OctetString aSN1OctetString) {
        this.ukm = aSN1OctetString;
    }

    void setWrapAlgorithmOID(DERObjectIdentifier dERObjectIdentifier) {
        this.wrapAlgorithmOID = dERObjectIdentifier;
    }

    void setWrapKey(SecretKey secretKey) {
        this.wrapKey = secretKey;
    }

    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)this.wrapAlgorithmOID);
        aSN1EncodableVector.add((DEREncodable)DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.algorithmOID, (DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.recipientTBSCert.getIssuer(), this.recipientTBSCert.getSerialNumber().getValue());
        Cipher cipher = CMSEnvelopedHelper.INSTANCE.createAsymmetricCipher(this.wrapAlgorithmOID.getId(), provider);
        cipher.init(3, (Key)this.wrapKey, secureRandom);
        DEROctetString dEROctetString = new DEROctetString(cipher.wrap(secretKey));
        RecipientEncryptedKey recipientEncryptedKey = new RecipientEncryptedKey(new KeyAgreeRecipientIdentifier(issuerAndSerialNumber), (ASN1OctetString)dEROctetString);
        return new RecipientInfo(new KeyAgreeRecipientInfo(this.originator, this.ukm, algorithmIdentifier, (ASN1Sequence)new DERSequence((DEREncodable)recipientEncryptedKey)));
    }
}

