/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;

public class RelationshipServiceImpl
extends AbstractAtomPubService
implements RelationshipService {
    public RelationshipServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectListImpl result = new ObjectListImpl();
        String link = this.loadLink(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/relationships", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/relationships", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("includeSubRelationshipTypes", (Object)includeSubRelationshipTypes);
        url.addParameter("relationshipDirection", (Object)relationshipDirection);
        url.addParameter("typeId", (Object)typeId);
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("maxItems", (Object)maxItems);
        url.addParameter("skipCount", (Object)skipCount);
        HttpUtils.Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                continue;
            }
            if (!this.isInt("numItems", element)) continue;
            result.setNumItems((BigInteger)element.getObject());
        }
        if (!feed.getEntries().isEmpty()) {
            result.setObjects(new ArrayList(feed.getEntries().size()));
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData relationship = null;
                this.lockLinks();
                try {
                    this.removeLinks(repositoryId, entry.getId());
                    for (AtomElement element : entry.getElements()) {
                        if (element.getObject() instanceof AtomLink) {
                            this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                            continue;
                        }
                        if (!(element.getObject() instanceof CmisObjectType)) continue;
                        relationship = Converter.convert((CmisObjectType)((CmisObjectType)element.getObject()));
                    }
                }
                finally {
                    this.unlockLinks();
                }
                if (relationship == null) continue;
                result.getObjects().add(relationship);
            }
        }
        return result;
    }
}

