/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.version.Version;
import aQute.libg.qtokens.QuotedTokenizer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapTask
extends BaseTask {
    List<File> jars = new ArrayList<File>();
    File output = null;
    File definitions = null;
    List<File> classpath = new ArrayList<File>();
    String bsn;
    Version version;
    boolean force;
    boolean failok;
    boolean exceptions;

    public void execute() throws BuildException {
        boolean failed;
        block14: {
            failed = false;
            try {
                if (this.jars == null) {
                    throw new BuildException("No files set", this.getLocation());
                }
                if (this.output != null && this.jars.size() > 1 && !this.output.isDirectory()) {
                    throw new BuildException("Multiple jars must be wrapped but the output given is not a directory " + this.output, this.getLocation());
                }
                if (this.definitions != null && this.jars.size() > 1 && !this.definitions.isDirectory()) {
                    throw new BuildException("Multiple jars must be wrapped but the definitions parameters is not a directory " + this.definitions, this.getLocation());
                }
                for (File file : this.jars) {
                    if (!file.isFile()) {
                        failed = true;
                        System.err.println("Non existent file to wrap " + file);
                        continue;
                    }
                    Analyzer wrapper = new Analyzer();
                    wrapper.setPedantic(this.isPedantic());
                    wrapper.setTrace(this.isTrace());
                    wrapper.setExceptions(this.exceptions);
                    wrapper.setBase(this.getProject().getBaseDir());
                    wrapper.addClasspath(this.classpath);
                    if (this.failok) {
                        wrapper.setFailOk(true);
                    }
                    wrapper.setJar(file);
                    wrapper.addProperties(this.getProject().getProperties());
                    wrapper.setDefaults(this.bsn, this.version);
                    File outputFile = wrapper.getOutputFile(this.output == null ? null : this.output.getAbsolutePath());
                    if (this.definitions != null) {
                        File properties = this.definitions;
                        if (properties.isDirectory()) {
                            String pfile = wrapper.replaceExtension(outputFile.getName(), ".jar", ".bnd");
                            properties = new File(this.definitions, pfile);
                        }
                        if (properties.isFile()) {
                            wrapper.setProperties(properties);
                        }
                    }
                    wrapper.calcManifest();
                    if (wrapper.isOk()) {
                        boolean saved = wrapper.save(outputFile, this.force);
                        this.log(String.format("%30s %6d %s%n", wrapper.getJar().getBsn() + "-" + wrapper.getJar().getVersion(), outputFile.length(), saved ? "" : "(not modified)"));
                    }
                    failed |= this.report(wrapper);
                }
            }
            catch (Exception e) {
                if (this.exceptions) {
                    e.printStackTrace();
                }
                if (this.failok) break block14;
                throw new BuildException("Failed to build jar file: " + e, this.getLocation());
            }
        }
        if (failed && !this.failok) {
            throw new BuildException("Failed to wrap jar file", this.getLocation());
        }
    }

    public void setJars(String files) {
        this.addAll(this.jars, files, ",");
    }

    void addAll(List<File> list, String files, String separator) {
        QuotedTokenizer qt = new QuotedTokenizer(files, separator);
        String[] entries = qt.getTokens();
        File project = this.getProject().getBaseDir();
        for (int i = 0; i < entries.length; ++i) {
            File f = WrapTask.getFile(project, entries[i]);
            if (f.exists()) {
                list.add(f);
                continue;
            }
            this.messages.NoSuchFile_(f.getAbsoluteFile());
        }
    }

    public void setClasspath(String files) {
        this.addAll(this.classpath, files, File.pathSeparator + ",");
    }

    boolean isFailok() {
        return this.failok;
    }

    public void setFailok(boolean failok) {
        this.failok = failok;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setDefinitions(File out) {
        this.definitions = out;
    }

    public void addConfiguredFileSet(FileSet list) {
        DirectoryScanner scanner = list.getDirectoryScanner(this.getProject());
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = WrapTask.getFile(scanner.getBasedir(), files[i]);
            this.jars.add(f);
        }
    }

    public void setVersion(String version) {
        this.version = new Version(version);
    }

    public void setBsn(String bsn) {
        this.bsn = bsn;
    }
}

