/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import java.awt.image.RGBImageFilter;

public class CheckFilter
extends RGBImageFilter {
    private int xScale = 8;
    private int yScale = 8;
    private int foreground = -1;
    private int background = -16777216;
    private int fuzziness = 0;
    private double angle = 0.0;
    private int operation;
    private double m00 = 1.0;
    private double m01 = 0.0;
    private double m10 = 0.0;
    private double m11 = 1.0;

    public void setForeground(int n) {
        this.foreground = n;
    }

    public int getForeground() {
        return this.foreground;
    }

    public void setBackground(int n) {
        this.background = n;
    }

    public int getBackground() {
        return this.background;
    }

    public void setXScale(int n) {
        this.xScale = n;
    }

    public int getXScale() {
        return this.xScale;
    }

    public void setYScale(int n) {
        this.yScale = n;
    }

    public int getYScale() {
        return this.yScale;
    }

    public void setFuzziness(int n) {
        this.fuzziness = n;
    }

    public int getFuzziness() {
        return this.fuzziness;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setAngle(double d) {
        this.angle = d;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = -d3;
        this.m11 = d2;
    }

    public double getAngle() {
        return this.angle;
    }

    public int filterRGB(int n, int n2, int n3) {
        double d;
        double d2 = (this.m00 * (double)n + this.m01 * (double)n2) / (double)this.xScale;
        double d3 = (this.m10 * (double)n + this.m11 * (double)n2) / (double)this.yScale;
        double d4 = d = (int)(d2 + 100000.0) % 2 != (int)(d3 + 100000.0) % 2 ? 1.0 : 0.0;
        if (this.fuzziness != 0) {
            double d5 = (double)this.fuzziness / 100.0;
            double d6 = ImageMath.smoothPulse(0.0, d5, 1.0 - d5, 1.0, ImageMath.mod(d2, 1.0));
            double d7 = ImageMath.smoothPulse(0.0, d5, 1.0 - d5, 1.0, ImageMath.mod(d3, 1.0));
            d = d == 0.0 ? 0.5 - d6 * d7 : 0.5 + d6 * d7;
        }
        return ImageMath.mixColors(d, this.foreground, this.background);
    }

    public String toString() {
        return "Texture/Checkerboard...";
    }
}

