/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ucar.grib.GribChecker;
import ucar.grib.GribIndexName;
import ucar.grib.grib1.Grib1WriteIndex;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.unidata.io.RandomAccessFile;

public final class GribBinaryIndexer {
    private static boolean removeGBX = false;
    private List<String> dirs = new ArrayList<String>();

    private boolean readConf(String conf) throws IOException {
        String line;
        FileInputStream ios = new FileInputStream(conf);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#")) continue;
            this.dirs.add(line);
        }
        ((InputStream)ios).close();
        return true;
    }

    private void clearLocks() {
        for (String dir : this.dirs) {
            File f = new File(dir + "/IndexLock");
            if (f.exists()) {
                f.delete();
                System.out.println("Cleared lock " + dir + "/IndexLock");
                continue;
            }
            System.out.println("In directory " + dir);
        }
    }

    private void indexer() throws IOException {
        System.out.println("Start " + Calendar.getInstance().getTime().toString());
        long start = System.currentTimeMillis();
        for (String dir : this.dirs) {
            File d = new File(dir);
            if (!d.exists()) {
                System.out.println("Dir " + dir + " doesn't exists");
                continue;
            }
            File dl = new File(dir + "/IndexLock");
            if (dl.exists()) {
                System.out.println("Exiting " + dir + " another Indexer working here");
                continue;
            }
            dl.createNewFile();
            this.checkDirs(d);
            dl.delete();
        }
        System.out.println("End " + Calendar.getInstance().getTime().toString());
        System.out.println("Total time in ms " + (System.currentTimeMillis() - start));
    }

    private void checkDirs(File dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String aChildren : children = dir.list()) {
                if (aChildren.equals("IndexLock")) continue;
                File child = new File(dir, aChildren);
                if (child.isDirectory()) {
                    this.checkDirs(child);
                    continue;
                }
                if (aChildren.endsWith(".gbx") || aChildren.endsWith(".gbx8") || aChildren.endsWith("xml") || aChildren.endsWith("tmp") || aChildren.length() == 0) continue;
                this.checkIndex(dir, child);
            }
        }
    }

    private void checkIndex(File dir, File grib) throws IOException {
        String[] args = new String[2];
        File gbx = new File(GribIndexName.getCurrentSuffix((String)grib.getPath()));
        if (removeGBX && gbx.exists()) {
            gbx.delete();
        }
        args[0] = grib.getPath();
        args[1] = gbx.getPath();
        if (gbx.exists()) {
            if (System.currentTimeMillis() - grib.lastModified() > 10800000L) {
                return;
            }
            if (gbx.length() == 0L) {
                System.out.println("ERROR " + args[1] + " has length zero");
                return;
            }
        }
        if (grib.getName().endsWith("grib1")) {
            this.grib1check(grib, gbx, args);
        } else if (grib.getName().endsWith("grib2")) {
            this.grib2check(grib, gbx, args);
        } else {
            RandomAccessFile raf = new RandomAccessFile(args[0], "r");
            int result = GribChecker.getEdition((RandomAccessFile)raf);
            if (result == 2) {
                this.grib2check(grib, gbx, args);
            } else if (result == 1) {
                this.grib1check(grib, gbx, args);
            } else {
                System.out.println("Not a Grib File " + args[0]);
            }
            raf.close();
        }
    }

    private void grib1check(File grib, File gbx, String[] args) {
        try {
            if (gbx.exists()) {
                if (grib.lastModified() < gbx.lastModified()) {
                    return;
                }
                long start = System.currentTimeMillis();
                new Grib1WriteIndex().extendGribIndex(grib, gbx, args[0], args[1], false);
                System.out.println("IndexExtending " + grib.getName() + " took " + (System.currentTimeMillis() - start) + " ms BufferSize " + Grib2WriteIndex.indexRafBufferSize);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            } else {
                long start = System.currentTimeMillis();
                new Grib1WriteIndex().writeGribIndex(grib, args[0], args[1], false);
                System.out.println("Indexing " + grib.getName() + " took " + (System.currentTimeMillis() - start) + " ms BufferSize " + Grib2WriteIndex.indexRafBufferSize);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Caught Exception doing index or inventory for " + grib.getName());
        }
    }

    private void grib2check(File grib, File gbx, String[] args) {
        try {
            if (gbx.exists()) {
                if (grib.lastModified() < gbx.lastModified()) {
                    return;
                }
                long start = System.currentTimeMillis();
                new Grib2WriteIndex().extendGribIndex(grib, gbx, args[0], args[1], false);
                System.out.println("IndexExtending " + grib.getName() + " took " + (System.currentTimeMillis() - start) + " ms BufferSize " + Grib2WriteIndex.indexRafBufferSize);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            } else {
                long start = System.currentTimeMillis();
                new Grib2WriteIndex().writeGribIndex(grib, args[0], args[1], false);
                System.out.println("Indexing " + grib.getName() + " took " + (System.currentTimeMillis() - start) + " ms BufferSize " + Grib2WriteIndex.indexRafBufferSize);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Caught Exception doing index or inventory for " + grib.getName());
        }
    }

    public static boolean test() throws IOException {
        String[] args;
        GribBinaryIndexer gi = new GribBinaryIndexer();
        args = new String[]{"C:/data/grib/g2p5U.grib2", GribIndexName.getCurrentSuffix((String)args[0])};
        File grib = new File(args[0]);
        File gbx = new File(args[1]);
        gi.grib2check(grib, gbx, args);
        return true;
    }

    public static void main(String[] args) throws IOException {
        GribBinaryIndexer gbi = new GribBinaryIndexer();
        boolean clear = false;
        for (String arg : args) {
            if (arg.equals("clear")) {
                clear = true;
                System.out.println("Clearing Index locks");
                continue;
            }
            if (arg.equals("remove")) {
                removeGBX = true;
                System.out.println("Removing all indexes");
                continue;
            }
            File f = new File(arg);
            if (!f.exists()) {
                System.out.println("Conf file " + arg + " doesn't exist: ");
                return;
            }
            gbi.readConf(arg);
        }
        if (clear) {
            gbi.clearLocks();
            return;
        }
        gbi.indexer();
    }
}

