/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMethod
extends MetadataAnnotatedElement {
    protected MetadataClass m_metadataClass;
    protected String m_returnType;
    protected List<String> m_parameters;
    protected MetadataMethod m_setMethod;
    protected MetadataMethod m_next;

    public MetadataMethod(MetadataFactory factory, MetadataClass metadataClass) {
        super(factory);
        this.m_metadataClass = metadataClass;
        this.m_parameters = new ArrayList<String>();
    }

    public void addParameter(String parameter) {
        this.m_parameters.add(parameter);
    }

    public MetadataClass getMetadataClass() {
        return this.m_metadataClass;
    }

    public MetadataMethod getNext() {
        return this.m_next;
    }

    public List<String> getParameters() {
        return this.m_parameters;
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public MetadataMethod getSetMethod() {
        if (this.m_setMethod == null) {
            this.m_setMethod = this.getSetMethod(this.getMetadataClass());
        }
        return this.m_setMethod;
    }

    public void setSetMethod(MetadataMethod method) {
        this.m_setMethod = method;
    }

    public MetadataMethod getSetMethod(MetadataClass cls) {
        String getMethodName = this.getName();
        List<String> params = Arrays.asList(this.getReturnType());
        MetadataMethod setMethod = null;
        if (getMethodName.startsWith("get")) {
            setMethod = cls.getMethod("set" + getMethodName.substring(3), params);
        } else {
            setMethod = cls.getMethod("set" + getMethodName.substring(2), params);
            if (setMethod == null) {
                setMethod = cls.getMethod("setIs" + getMethodName.substring(2), params);
            }
        }
        return setMethod;
    }

    public String getSetMethodName() {
        return this.getSetMethod().getName();
    }

    public boolean hasAttributeName() {
        return !this.getAttributeName().equals("");
    }

    public boolean hasParameters() {
        return this.getParameters().size() > 0;
    }

    public boolean hasSetMethod() {
        return this.getSetMethod() != null;
    }

    protected boolean isALifeCycleCallbackMethod() {
        return this.isAnnotationPresent(PostLoad.class) || this.isAnnotationPresent(PostPersist.class) || this.isAnnotationPresent(PostRemove.class) || this.isAnnotationPresent(PostUpdate.class) || this.isAnnotationPresent(PrePersist.class) || this.isAnnotationPresent(PreRemove.class) || this.isAnnotationPresent(PreUpdate.class);
    }

    protected boolean isValidPersistenceMethod() {
        return this.isValidPersistenceMethodName() && !this.hasParameters() && this.hasSetMethod();
    }

    public boolean isValidPersistenceMethod(boolean mustBeExplicit, MetadataDescriptor descriptor) {
        if (this.isValidPersistenceElement(mustBeExplicit, "PROPERTY", descriptor)) {
            return !this.isALifeCycleCallbackMethod() && this.isValidPersistenceMethod(descriptor, this.hasDeclaredAnnotations(descriptor));
        }
        return false;
    }

    public boolean isValidPersistenceMethod(MetadataDescriptor descriptor, boolean userDecorated) {
        if (!this.isValidPersistenceElement(this.getModifiers()) || !this.isValidPersistenceMethod()) {
            if (userDecorated) {
                if (this.hasParameters()) {
                    throw ValidationException.mappingMetadataAppliedToMethodWithArguments(this, descriptor.getJavaClass());
                }
                if (!this.hasSetMethod()) {
                    throw ValidationException.noCorrespondingSetterMethodDefined(descriptor.getJavaClass(), this);
                }
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapping_metadata", this, (Object)descriptor.getJavaClass());
            }
            return false;
        }
        return true;
    }

    public boolean isValidPersistenceMethodName() {
        return (this.getName().startsWith("get") || this.getName().startsWith("is")) && this.hasAttributeName();
    }

    public void setMetadataClass(MetadataClass metadataClass) {
        this.m_metadataClass = metadataClass;
    }

    public void setNext(MetadataMethod next) {
        this.m_next = next;
    }

    public void setParameters(List<String> parameters) {
        this.m_parameters = parameters;
    }

    public void setReturnType(String returnType) {
        this.m_returnType = returnType;
        this.setType(returnType);
    }
}

