/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.template;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateVariableCodeHandler;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Writer;
import java.net.URL;

public class DDMTemplateVariableCodeHandler
implements TemplateVariableCodeHandler {
    private String _templatePath;

    public DDMTemplateVariableCodeHandler(String templatePath) {
        this._templatePath = templatePath;
    }

    public String[] generate(TemplateVariableDefinition templateVariableDefinition, String language) throws Exception {
        String resourceName = this.getResourceName(templateVariableDefinition.getDataType());
        Template template = this.getTemplate(resourceName);
        String content = this.getTemplateContent(template, templateVariableDefinition, language);
        if (templateVariableDefinition.isRepeatable()) {
            content = this.handleRepeatableField(templateVariableDefinition, language, content);
        }
        return new String[]{content};
    }

    protected String getResourceName(String dataType) {
        if (this.isCommonResource(dataType)) {
            dataType = "common";
        }
        StringBundler sb = new StringBundler(3);
        sb.append(this._templatePath);
        sb.append(dataType);
        sb.append(".ftl");
        return sb.toString();
    }

    protected Template getTemplate(String resource) throws Exception {
        TemplateResource templateResource = this.getTemplateResource(resource);
        return TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
    }

    protected String getTemplateContent(Template template, TemplateVariableDefinition templateVariableDefinition, String language) throws Exception {
        this.prepareTemplate(template, templateVariableDefinition, language);
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate((Writer)writer);
        return StringUtil.trim((String)writer.toString());
    }

    protected TemplateResource getTemplateResource(String resource) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL url = classLoader.getResource(resource);
        return new URLTemplateResource(resource, url);
    }

    protected String handleRepeatableField(TemplateVariableDefinition templateVariableDefinition, String language, String templateContent) throws Exception {
        Template template = this.getTemplate(String.valueOf(this._templatePath) + "repeatable.ftl");
        templateContent = StringUtil.replace((String)templateContent, (String)"\n", (String)"\n\t\t");
        template.put("templateContent", (Object)templateContent);
        return this.getTemplateContent(template, templateVariableDefinition, language);
    }

    protected boolean isCommonResource(String dataType) {
        return !dataType.equals("boolean") && !dataType.equals("date") && !dataType.equals("document-library") && !dataType.equals("image") && !dataType.equals("link-to-page");
    }

    protected void prepareTemplate(Template template, TemplateVariableDefinition templateVariableDefinition, String language) {
        template.put("dataType", (Object)templateVariableDefinition.getDataType());
        template.put("help", (Object)templateVariableDefinition.getHelp());
        template.put("label", (Object)templateVariableDefinition.getLabel());
        template.put("language", (Object)language);
        template.put("name", (Object)templateVariableDefinition.getName());
        template.put("repeatable", (Object)templateVariableDefinition.isRepeatable());
    }
}

