/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Enumeration;

public class TCKtoJUnitConverter {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new TCKtoJUnitConverter(args[0], args[1]);
    }

    public TCKtoJUnitConverter(String inputFile, String outputDir) {
        try {
            this._convert(new File(inputFile), new File(outputDir));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void _convert(File inputFile, File outputDir) throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(inputFile));
        String s = "";
        while ((s = unsyncBufferedReader.readLine()) != null) {
            if (!s.startsWith("Test finished: ")) continue;
            int x = s.indexOf("#");
            int y = s.lastIndexOf("/", x);
            String className = s.substring(15, y);
            className = StringUtil.replace((String)className, (String)"/", (String)".");
            if ((y = s.indexOf(":", y)) == -1) {
                y = s.length();
            }
            className = String.valueOf(className) + "." + s.substring(x + 1, y);
            String message = s.substring(y + 2);
            this._convert(className, message, outputDir);
        }
        unsyncBufferedReader.close();
    }

    private void _convert(String className, String message, File outputDir) throws Exception {
        boolean passed = false;
        if (message.startsWith("Passed.")) {
            passed = true;
        }
        String hostname = GetterUtil.getString((String)System.getProperty("env.USERDOMAIN"));
        hostname = StringUtil.toLowerCase((String)hostname);
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<testsuite errors=\"");
        if (passed) {
            sb.append("0");
        } else {
            sb.append("1");
        }
        sb.append("\" failures=\"");
        if (passed) {
            sb.append("1");
        } else {
            sb.append("0");
        }
        sb.append("\" hostname=\"");
        sb.append(hostname);
        sb.append("\" name=\"");
        sb.append(className);
        sb.append("\" tests=\"1\" time=\"0.0\" timestamp=\"");
        sb.append(System.currentTimeMillis());
        sb.append("\">\n");
        sb.append("\t<properties>\n");
        SortedProperties properties = new SortedProperties(System.getProperties());
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            sb.append("\t\t<property name=\"");
            sb.append(HtmlUtil.escape((String)key));
            sb.append("\" value=\"");
            sb.append(HtmlUtil.escape((String)value));
            sb.append("\" />\n");
        }
        sb.append("\t</properties>\n");
        sb.append("\t<testcase classname=\"");
        sb.append(className);
        sb.append("\" name=\"test\" time=\"0.0\"");
        if (passed) {
            sb.append(" />\n");
        } else {
            String failureMessage = HtmlUtil.escape((String)message.substring(8));
            sb.append(">\n");
            sb.append("\t\t<failure message=\"");
            sb.append(failureMessage);
            sb.append("\" type=\"junit.framework.AssertionFailedError\">\n");
            sb.append(failureMessage);
            sb.append("\n\t\t</failure>\n");
            sb.append("\t</testcase>\n");
        }
        sb.append("\t<system-out><![CDATA[]]></system-out>\n");
        sb.append("\t<system-err><![CDATA[]]></system-err>\n");
        sb.append("</testsuite>");
        FileUtil.write((String)(outputDir + "/TEST-" + className + ".xml"), (String)sb.toString());
    }
}

