/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import org.hibernate.Session;

public class LastSessionRecorderUtil {
    private static ThreadLocal<Session> _lastSessionThreadLocal = new AutoResetThreadLocal(String.valueOf(LastSessionRecorderUtil.class.getName()) + "._lastSessionThreadLocal");

    public static void syncLastSessionState() throws SystemException {
        Session session = _lastSessionThreadLocal.get();
        if (session != null && session.isOpen()) {
            try {
                session.flush();
                session.clear();
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
    }

    protected static void setLastSession(Session session) {
        _lastSessionThreadLocal.set(session);
    }
}

