/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.patcher;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.patcher.PatchInconsistencyException;
import com.liferay.portal.kernel.patcher.Patcher;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

@DoPrivileged
public class PatcherImpl
implements Patcher {
    private static Log _log = LogFactoryUtil.getLog(PatcherImpl.class);
    private static boolean _configured;
    private static String[] _fixedIssueKeys;
    private static boolean _inconsistentPatchLevels;
    private static String[] _installedPatchNames;
    private static File _patchDirectory;
    private static String[] _patchLevels;
    private static Properties _properties;

    public boolean applyPatch(File patchFile) {
        File patchDirectory = this.getPatchDirectory();
        if (patchDirectory == null) {
            return false;
        }
        try {
            FileUtil.copyFile((File)patchFile, (File)new File(patchDirectory + "/" + patchFile.getName()));
            return true;
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to copy " + patchFile.getAbsolutePath() + " to " + patchDirectory.getAbsolutePath()));
            return false;
        }
    }

    public String[] getFixedIssues() {
        if (_fixedIssueKeys != null) {
            return _fixedIssueKeys;
        }
        Properties properties = this.getProperties();
        _fixedIssueKeys = StringUtil.split((String)properties.getProperty("fixed.issues"));
        return _fixedIssueKeys;
    }

    public String[] getInstalledPatches() {
        if (_installedPatchNames != null) {
            return _installedPatchNames;
        }
        return this._getInstalledPatches(null);
    }

    public File getPatchDirectory() {
        if (_patchDirectory != null) {
            return _patchDirectory;
        }
        Properties properties = this.getProperties();
        String patchDirectoryName = properties.getProperty("patch.directory");
        if (Validator.isNotNull((String)patchDirectoryName)) {
            _patchDirectory = new File(patchDirectoryName);
            if (!_patchDirectory.exists()) {
                _log.error((Object)"The patch directory does not exist");
            }
        } else {
            _log.error((Object)"The patch directory is not specified");
        }
        return _patchDirectory;
    }

    public String[] getPatchLevels() {
        if (_patchLevels != null) {
            return _patchLevels;
        }
        Properties properties = this.getProperties();
        _patchLevels = StringUtil.split((String)properties.getProperty("patch.levels"));
        return _patchLevels;
    }

    public Properties getProperties() {
        if (_properties != null) {
            return _properties;
        }
        return this._getProperties("patcher.properties");
    }

    public boolean isConfigured() {
        return _configured;
    }

    public boolean hasInconsistentPatchLevels() {
        return _inconsistentPatchLevels;
    }

    public void verifyPatchLevels() throws PatchInconsistencyException {
        Properties portalImplJARProperties = this._getProperties("patcher.properties");
        Object[] portalImplJARPatches = this._getInstalledPatches(portalImplJARProperties);
        Arrays.sort(portalImplJARPatches);
        Properties portalServiceJARProperties = this._getProperties("patcher-service.properties");
        Object[] serviceJARPatches = this._getInstalledPatches(portalServiceJARProperties);
        Arrays.sort(serviceJARPatches);
        if (!Arrays.equals(portalImplJARPatches, serviceJARPatches)) {
            _log.error((Object)"Inconsistent patch level detected");
            if (_log.isWarnEnabled()) {
                if (ArrayUtil.isEmpty((Object[])portalImplJARPatches)) {
                    _log.warn((Object)"There are no patches installed on portal-impl.jar");
                } else {
                    _log.warn((Object)("Patch level on portal-impl.jar: " + Arrays.toString(portalImplJARPatches)));
                }
                if (ArrayUtil.isEmpty((Object[])serviceJARPatches)) {
                    _log.warn((Object)"There are no patches installed on portal-service.jar");
                } else {
                    _log.warn((Object)("Patch level on portal-service.jar: " + Arrays.toString(serviceJARPatches)));
                }
            }
            _inconsistentPatchLevels = true;
            throw new PatchInconsistencyException();
        }
    }

    private String[] _getInstalledPatches(Properties properties) {
        if (properties == null) {
            properties = this.getProperties();
        }
        _installedPatchNames = StringUtil.split((String)properties.getProperty("installed.patches"));
        return _installedPatchNames;
    }

    private Properties _getProperties(String fileName) {
        Properties properties;
        block10: {
            ClassLoader classLoader;
            InputStream inputStream;
            if (Validator.isNull((String)fileName)) {
                fileName = "patcher.properties";
            }
            properties = new Properties();
            Class<?> clazz = this.getClass();
            if (Validator.equals((Object)fileName, (Object)"patcher-service.properties")) {
                clazz = clazz.getInterfaces()[0];
            }
            if ((inputStream = (classLoader = clazz.getClassLoader()).getResourceAsStream(fileName)) == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to load " + fileName));
                }
            } else {
                try {
                    try {
                        properties.load(inputStream);
                        _configured = true;
                    }
                    catch (IOException ioe) {
                        _log.error((Object)ioe, (Throwable)ioe);
                        StreamUtil.cleanUp((InputStream)inputStream);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((InputStream)inputStream);
                    throw throwable;
                }
                StreamUtil.cleanUp((InputStream)inputStream);
            }
        }
        _properties = properties;
        return _properties;
    }
}

