/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asset;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AssetRendererFactoryRegistryImpl
implements AssetRendererFactoryRegistry {
    private static Log _log = LogFactoryUtil.getLog(AssetRendererFactoryRegistryImpl.class);
    private Map<String, AssetRendererFactory> _assetRenderFactoriesMapByClassName = new ConcurrentHashMap<String, AssetRendererFactory>();
    private Map<String, AssetRendererFactory> _assetRenderFactoriesMapByClassType = new ConcurrentHashMap<String, AssetRendererFactory>();

    public List<AssetRendererFactory> getAssetRendererFactories() {
        return ListUtil.fromMapValues(this._assetRenderFactoriesMapByClassName);
    }

    public List<AssetRendererFactory> getAssetRendererFactories(long companyId) {
        return ListUtil.fromMapValues(this.filterAssetRendererFactories(companyId, this._assetRenderFactoriesMapByClassName));
    }

    public AssetRendererFactory getAssetRendererFactoryByClassName(String className) {
        return this._assetRenderFactoriesMapByClassName.get(className);
    }

    public AssetRendererFactory getAssetRendererFactoryByType(String type) {
        return this._assetRenderFactoriesMapByClassType.get(type);
    }

    public long[] getClassNameIds() {
        return this.getClassNameIds(0L);
    }

    public long[] getClassNameIds(long companyId) {
        Map<String, AssetRendererFactory> assetRenderFactories = this._assetRenderFactoriesMapByClassName;
        if (companyId > 0L) {
            assetRenderFactories = this.filterAssetRendererFactories(companyId, this._assetRenderFactoriesMapByClassName);
        }
        long[] classNameIds = new long[assetRenderFactories.size()];
        int i2 = 0;
        for (AssetRendererFactory assetRendererFactory : assetRenderFactories.values()) {
            classNameIds[i2] = assetRendererFactory.getClassNameId();
            ++i2;
        }
        return classNameIds;
    }

    public void register(AssetRendererFactory assetRendererFactory) {
        String className = assetRendererFactory.getClassName();
        AssetRendererFactory classNameAssetRendererFactory = this._assetRenderFactoriesMapByClassName.put(className, assetRendererFactory);
        if (_log.isWarnEnabled() && classNameAssetRendererFactory != null) {
            _log.warn((Object)("Replacing " + classNameAssetRendererFactory + " for class name " + className + " with " + assetRendererFactory));
        }
        String type = assetRendererFactory.getType();
        AssetRendererFactory typeAssetRendererFactory = this._assetRenderFactoriesMapByClassType.put(type, assetRendererFactory);
        if (_log.isWarnEnabled() && typeAssetRendererFactory != null) {
            _log.warn((Object)("Replacing " + typeAssetRendererFactory + " for type " + type + " with " + assetRendererFactory));
        }
    }

    public void unregister(AssetRendererFactory assetRendererFactory) {
        this._assetRenderFactoriesMapByClassName.remove(assetRendererFactory.getClassName());
        this._assetRenderFactoriesMapByClassType.remove(assetRendererFactory.getType());
    }

    private Map<String, AssetRendererFactory> filterAssetRendererFactories(long companyId, Map<String, AssetRendererFactory> assetRendererFactories) {
        ConcurrentHashMap<String, AssetRendererFactory> filteredAssetRendererFactories = new ConcurrentHashMap<String, AssetRendererFactory>();
        for (String className : assetRendererFactories.keySet()) {
            AssetRendererFactory assetRendererFactory = assetRendererFactories.get(className);
            if (!assetRendererFactory.isActive(companyId)) continue;
            filteredAssetRendererFactories.put(className, assetRendererFactory);
        }
        return filteredAssetRendererFactories;
    }
}

