/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PhotoFormatter {
    public static final int RESIZE_WIDTH = 96;
    public static final int RESIZE_HEIGHT = 96;

    public BufferedImage resize(File file) throws IOException {
        return this.resize(ImageIO.read(file));
    }

    public BufferedImage resize(Image photo) throws IOException {
        BufferedImage img = new BufferedImage(96, 96, 1);
        Graphics2D g = img.createGraphics();
        if (photo.getWidth(null) > photo.getHeight(null)) {
            float gap = (photo.getWidth(null) - photo.getHeight(null)) / 2;
            float ratio = 96.0f / (float)photo.getHeight(null);
            float gapNew = gap * ratio;
            g.drawImage(photo, (int)(-gapNew), 0, (int)(96.0f + gapNew * 2.0f), 96, null);
        } else if (photo.getWidth(null) < photo.getHeight(null)) {
            float gap = (photo.getHeight(null) - photo.getWidth(null)) / 2;
            float ratio = 96.0f / (float)photo.getWidth(null);
            float gapNew = gap * ratio;
            g.drawImage(photo, 0, (int)(-gapNew), 96, (int)(96.0f + gapNew * 2.0f), null);
        } else {
            g.drawImage(photo, 0, 0, 96, 96, null);
        }
        g.dispose();
        return img;
    }

    public byte[] getPNGBytes(BufferedImage img) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "PNG", out);
        out.close();
        return out.toByteArray();
    }
}

