/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import net.oauth.jsontoken.crypto.AbstractSigner;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;

public class RsaSHA256Signer
extends AbstractSigner {
    private final Signature signature;
    private final PrivateKey signingKey;

    public RsaSHA256Signer(String issuer, String keyId, RSAPrivateKey key) throws InvalidKeyException {
        super(issuer, keyId);
        this.signingKey = key;
        try {
            this.signature = Signature.getInstance("SHA256withRSA");
            this.signature.initSign(this.signingKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("platform is missing RSAwithSHA256 signature alg, or key is invalid", e);
        }
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.RS256;
    }

    @Override
    public byte[] sign(byte[] source) throws SignatureException {
        try {
            this.signature.initSign(this.signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("key somehow became invalid since calling the constructor");
        }
        this.signature.update(source);
        return this.signature.sign();
    }
}

