/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxEvaluationsExceededException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableMultivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateVectorialFunction;
import org.apache.commons.math.optimization.DifferentiableMultivariateRealOptimizer;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.SimpleScalarValueChecker;

public abstract class AbstractScalarDifferentiableOptimizer
implements DifferentiableMultivariateRealOptimizer {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    private int maxIterations;
    private int iterations;
    private int maxEvaluations;
    private int evaluations;
    private int gradientEvaluations;
    protected RealConvergenceChecker checker;
    private DifferentiableMultivariateRealFunction f;
    private MultivariateVectorialFunction gradient;
    protected GoalType goalType;
    protected double[] point;

    protected AbstractScalarDifferentiableOptimizer() {
        this.setConvergenceChecker(new SimpleScalarValueChecker());
        this.setMaxIterations(100);
        this.setMaxEvaluations(Integer.MAX_VALUE);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public int getGradientEvaluations() {
        return this.gradientEvaluations;
    }

    public void setConvergenceChecker(RealConvergenceChecker checker) {
        this.checker = checker;
    }

    public RealConvergenceChecker getConvergenceChecker() {
        return this.checker;
    }

    protected void incrementIterationsCounter() throws OptimizationException {
        if (++this.iterations > this.maxIterations) {
            throw new OptimizationException(new MaxIterationsExceededException(this.maxIterations));
        }
    }

    protected double[] computeObjectiveGradient(double[] point) throws FunctionEvaluationException {
        ++this.gradientEvaluations;
        return this.gradient.value(point);
    }

    protected double computeObjectiveValue(double[] point) throws FunctionEvaluationException {
        if (++this.evaluations > this.maxEvaluations) {
            throw new FunctionEvaluationException((Throwable)new MaxEvaluationsExceededException(this.maxEvaluations), point);
        }
        return this.f.value(point);
    }

    public RealPointValuePair optimize(DifferentiableMultivariateRealFunction f, GoalType goalType, double[] startPoint) throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        this.iterations = 0;
        this.evaluations = 0;
        this.gradientEvaluations = 0;
        this.f = f;
        this.gradient = f.gradient();
        this.goalType = goalType;
        this.point = (double[])startPoint.clone();
        return this.doOptimize();
    }

    protected abstract RealPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException;
}

