/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.test.DescriptionComparator;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class NewJVMJUnitTestRunner
extends BlockJUnit4ClassRunner {
    private static final String _JPDA_OPTIONS = "-agentlib:jdwp=transport=dt_socket,address=8001,server=y,suspend=y";
    private String _classPath = ClassPathUtil.getJVMClassPath(false);

    public NewJVMJUnitTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.sort(new Sorter((Comparator)new DescriptionComparator()));
    }

    protected static void attachProcess(String message) {
        if (!Boolean.getBoolean("attached")) {
            ProcessExecutor.ProcessContext.attach(message, 1000L, new ProcessExecutor.ShutdownHook(){

                @Override
                public boolean shutdown(int shutdownCode, Throwable shutdownThrowable) {
                    System.exit(shutdownCode);
                    return true;
                }
            });
            System.setProperty("attached", "true");
        }
    }

    protected List<String> createArguments(FrameworkMethod frameworkMethod) {
        boolean junitDebug;
        boolean junitCodeCoverage;
        boolean coberturaParentDynamicallyInstrumented;
        ArrayList<String> arguments = new ArrayList<String>();
        String agentLine = System.getProperty("junit.cobertura.agent");
        if (Validator.isNotNull(agentLine)) {
            arguments.add(agentLine);
            arguments.add("-Djunit.cobertura.agent=" + agentLine);
        }
        if (coberturaParentDynamicallyInstrumented = Boolean.getBoolean("cobertura.parent.dynamically.instrumented")) {
            arguments.add("-Dcobertura.parent.dynamically.instrumented=true");
        }
        if (junitCodeCoverage = Boolean.getBoolean("junit.code.coverage")) {
            arguments.add("-Djunit.code.coverage=true");
        }
        if (junitDebug = Boolean.getBoolean("junit.debug")) {
            arguments.add(_JPDA_OPTIONS);
            arguments.add("-Djunit.debug=true");
        }
        arguments.add("-Djava.net.preferIPv4Stack=true");
        String fileName = System.getProperty("net.sourceforge.cobertura.datafile");
        if (fileName != null) {
            arguments.add("-Dnet.sourceforge.cobertura.datafile=" + fileName);
        }
        return arguments;
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        PortalClassLoaderUtil.setClassLoader(contextClassLoader);
        TestClass testClass = this.getTestClass();
        List beforeFrameworkMethods = testClass.getAnnotatedMethods(Before.class);
        List afterFrameworkMethods = testClass.getAnnotatedMethods(After.class);
        List<String> arguments = this.createArguments(frameworkMethod);
        Class clazz = testClass.getJavaClass();
        return new RunInNewJVMStatment(this._classPath, arguments, clazz, beforeFrameworkMethods, frameworkMethod, afterFrameworkMethods);
    }

    protected ProcessCallable<Serializable> processProcessCallable(ProcessCallable<Serializable> processCallable, MethodKey testMethodKey) {
        return processCallable;
    }

    private class RunInNewJVMStatment
    extends Statement {
        private List<MethodKey> _afterMethodKeys;
        private List<String> _arguments;
        private List<MethodKey> _beforeMethodKeys;
        private String _classPath;
        private String _testClassName;
        private MethodKey _testMethodKey;

        public RunInNewJVMStatment(String classPath, List<String> arguments, Class<?> testClass, List<FrameworkMethod> beforeFrameworkMethods, FrameworkMethod testFrameworkMethod, List<FrameworkMethod> afterFrameworkMethods) {
            this._classPath = classPath;
            this._arguments = arguments;
            this._testClassName = testClass.getName();
            this._beforeMethodKeys = new ArrayList<MethodKey>(beforeFrameworkMethods.size());
            for (FrameworkMethod frameworkMethod : beforeFrameworkMethods) {
                this._beforeMethodKeys.add(new MethodKey(frameworkMethod.getMethod()));
            }
            this._testMethodKey = new MethodKey(testFrameworkMethod.getMethod());
            this._afterMethodKeys = new ArrayList<MethodKey>(afterFrameworkMethods.size());
            for (FrameworkMethod frameworkMethod : afterFrameworkMethods) {
                this._afterMethodKeys.add(new MethodKey(frameworkMethod.getMethod()));
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void evaluate() throws Throwable {
            block3: {
                processCallable /* !! */  = new TestProcessCallable(this._testClassName, this._beforeMethodKeys, this._testMethodKey, this._afterMethodKeys);
                processCallable /* !! */  = NewJVMJUnitTestRunner.this.processProcessCallable(processCallable /* !! */ , this._testMethodKey);
                future = ProcessExecutor.execute(this._classPath, this._arguments, processCallable /* !! */ );
                try {
                    future.get();
                    break block3;
                }
                catch (ExecutionException ee) {
                    cause = ee.getCause();
                    ** while (cause instanceof ProcessException || cause instanceof InvocationTargetException)
                }
lbl-1000:
                // 1 sources

                {
                    cause = cause.getCause();
                    continue;
                }
lbl13:
                // 1 sources

                throw cause;
            }
        }
    }

    private static class TestProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private List<MethodKey> _afterMethodKeys;
        private List<MethodKey> _beforeMethodKeys;
        private String _testClassName;
        private MethodKey _testMethodKey;

        public TestProcessCallable(String testClassName, List<MethodKey> beforeMethodKeys, MethodKey testMethodKey, List<MethodKey> afterMethodKeys) {
            this._testClassName = testClassName;
            this._beforeMethodKeys = beforeMethodKeys;
            this._testMethodKey = testMethodKey;
            this._afterMethodKeys = afterMethodKeys;
        }

        @Override
        public Serializable call() throws ProcessException {
            NewJVMJUnitTestRunner.attachProcess("Attached " + this.toString());
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                Class<?> clazz = contextClassLoader.loadClass(this._testClassName);
                Object object = clazz.newInstance();
                for (MethodKey beforeMethodKey : this._beforeMethodKeys) {
                    beforeMethodKey = beforeMethodKey.transform(contextClassLoader);
                    this._invoke(beforeMethodKey, object);
                }
                MethodKey testMethodKey = this._testMethodKey.transform(contextClassLoader);
                this._invoke(testMethodKey, object);
                for (MethodKey afterMethodKey : this._afterMethodKeys) {
                    afterMethodKey = afterMethodKey.transform(contextClassLoader);
                    this._invoke(afterMethodKey, object);
                }
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
            return "";
        }

        public String toString() {
            StringBundler sb = new StringBundler(4);
            sb.append(this._testClassName);
            sb.append(".");
            sb.append(this._testMethodKey.getMethodName());
            sb.append("()");
            return sb.toString();
        }

        private void _invoke(MethodKey methodKey, Object object) throws Exception {
            Method method = methodKey.getMethod();
            method.invoke(object, new Object[0]);
        }
    }
}

