/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.ScrollableResults;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnmodifiableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QueryUtil {
    public static final int ALL_POS = -1;
    private static Log _log = LogFactoryUtil.getLog(QueryUtil.class);

    public static Comparable<?>[] getPrevAndNext(Query query, int count, OrderByComparator obc, Comparable<?> comparable) {
        int pos = count;
        int boundary = 0;
        Comparable[] array = new Comparable[3];
        DB db = DBFactoryUtil.getDB();
        if (!db.isSupportsScrollableResults()) {
            if (_log.isWarnEnabled()) {
                _log.warn("Database does not support scrollable results");
            }
            return array;
        }
        ScrollableResults sr = query.scroll();
        if (sr.first()) {
            int value;
            int scrollPos;
            do {
                Object obj;
                if ((obj = sr.get(0)) == null) {
                    if (!_log.isWarnEnabled()) break;
                    _log.warn("Object is null");
                    break;
                }
                Comparable curComparable = (Comparable)obj;
                value = obc.compare(comparable, curComparable);
                if (_log.isDebugEnabled()) {
                    _log.debug("Comparison result is " + value);
                }
                if (value == 0) {
                    if (!comparable.equals(curComparable)) break;
                    array[1] = curComparable;
                    if (sr.previous()) {
                        array[0] = (Comparable)sr.get(0);
                    }
                    sr.next();
                    if (!sr.next()) break;
                    array[2] = (Comparable)sr.get(0);
                    break;
                }
                if (pos == 1) break;
                scrollPos = pos = (int)Math.ceil((double)pos / 2.0);
                if (value < 0) {
                    scrollPos *= -1;
                }
                if ((boundary += scrollPos) < 0) {
                    scrollPos = scrollPos + boundary * -1 + 1;
                    boundary = 0;
                }
                if (boundary > count) {
                    scrollPos -= boundary - count;
                    boundary = scrollPos;
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug("Scroll " + scrollPos);
            } while (sr.scroll(scrollPos) || !(value < 0 ? !sr.next() : !sr.previous()));
        }
        return array;
    }

    public static Iterator<?> iterate(Query query, Dialect dialect, int start, int end) {
        return QueryUtil.iterate(query, dialect, start, end, true);
    }

    public static Iterator<?> iterate(Query query, Dialect dialect, int start, int end, boolean unmodifiable) {
        return QueryUtil.list(query, dialect, start, end).iterator();
    }

    public static List<?> list(Query query, Dialect dialect, int start, int end) {
        return QueryUtil.list(query, dialect, start, end, true);
    }

    public static List<?> list(Query query, Dialect dialect, int start, int end, boolean unmodifiable) {
        if (start == -1 && end == -1) {
            return query.list(unmodifiable);
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (start == end) {
            if (unmodifiable) {
                return Collections.emptyList();
            }
            return new ArrayList();
        }
        if (dialect.supportsLimit()) {
            query.setMaxResults(end - start);
            query.setFirstResult(start);
            return query.list(unmodifiable);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        DB db = DBFactoryUtil.getDB();
        if (!db.isSupportsScrollableResults()) {
            if (_log.isWarnEnabled()) {
                _log.warn("Database does not support scrollable results");
            }
            return list;
        }
        ScrollableResults sr = query.scroll();
        if (sr.first() && sr.scroll(start)) {
            int i = start;
            while (i < end) {
                Object[] array = sr.get();
                if (array.length == 1) {
                    list.add(array[0]);
                } else {
                    list.add(array);
                }
                if (!sr.next()) break;
                ++i;
            }
        }
        if (unmodifiable) {
            return new UnmodifiableList(list);
        }
        return list;
    }

    public static List<?> randomList(Query query, Dialect dialect, int total, int num) {
        return QueryUtil.randomList(query, dialect, total, num, true);
    }

    public static List<?> randomList(Query query, Dialect dialect, int total, int num, boolean unmodifiable) {
        if (total == 0 || num == 0) {
            return new ArrayList();
        }
        if (num >= total) {
            return QueryUtil.list(query, dialect, -1, -1, true);
        }
        int[] scrollIds = RandomUtil.nextInts(total, num);
        ArrayList<Object> list = new ArrayList<Object>();
        DB db = DBFactoryUtil.getDB();
        if (!db.isSupportsScrollableResults()) {
            if (_log.isWarnEnabled()) {
                _log.warn("Database does not support scrollable results");
            }
            return list;
        }
        ScrollableResults sr = query.scroll();
        int i = 0;
        while (i < scrollIds.length) {
            if (sr.scroll(scrollIds[i])) {
                Object[] array = sr.get();
                if (array.length == 1) {
                    list.add(array[0]);
                } else {
                    list.add(array);
                }
                sr.first();
            }
            ++i;
        }
        if (unmodifiable) {
            return new UnmodifiableList(list);
        }
        return list;
    }
}

