/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.facets.impl.DynamicRangeFacetHandler;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DynamicTimeRangeFacetHandler
extends DynamicRangeFacetHandler {
    private static final Logger log = Logger.getLogger((String)DynamicTimeRangeFacetHandler.class.getName());
    public static final String NUMBER_FORMAT = "00000000000000000000";
    protected ThreadLocal<DecimalFormat> _formatter = null;
    public static long MILLIS_IN_DAY = 86400000L;
    public static long MILLIS_IN_HOUR = 3600000L;
    public static long MILLIS_IN_MIN = 60000L;
    public static long MILLIS_IN_SEC = 1000L;
    private final HashMap<String, String> _valueToRangeStringMap;
    private final HashMap<String, String> _rangeStringToValueMap;
    private final ArrayList<String> _rangeStringList;

    public DynamicTimeRangeFacetHandler(String name, String dataFacetName, long currentTime, List<String> ranges) throws ParseException {
        super(name, dataFacetName);
        this._formatter = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat(DynamicTimeRangeFacetHandler.NUMBER_FORMAT);
            }
        };
        if (log.isDebugEnabled()) {
            log.debug((Object)(name + " " + dataFacetName + " " + currentTime));
        }
        ArrayList<String> sortedRanges = new ArrayList<String>(ranges);
        Collections.sort(sortedRanges);
        this._valueToRangeStringMap = new HashMap();
        this._rangeStringToValueMap = new HashMap();
        this._rangeStringList = new ArrayList(ranges.size());
        String prev = "000000000";
        for (String range : sortedRanges) {
            String rangeString = this.buildRangeString(currentTime, prev, range);
            this._valueToRangeStringMap.put(range, rangeString);
            this._rangeStringToValueMap.put(rangeString, range);
            this._rangeStringList.add(rangeString);
            prev = range;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(range + "\t " + rangeString));
        }
    }

    private DynamicTimeRangeFacetHandler(String name, String dataFacetName, HashMap<String, String> valueToRangeStringMap, HashMap<String, String> rangeStringToValueMap, ArrayList<String> rangeStringList) {
        super(name, dataFacetName);
        this._valueToRangeStringMap = valueToRangeStringMap;
        this._rangeStringToValueMap = rangeStringToValueMap;
        this._rangeStringList = rangeStringList;
    }

    private static long getTime(long time, String range) throws ParseException {
        if (range.length() != 9) {
            throw new ParseException("invalid range format: " + range, 0);
        }
        try {
            int val = Integer.parseInt(range.substring(0, 3));
            time -= (long)val * MILLIS_IN_DAY;
            val = Integer.parseInt(range.substring(3, 5));
            if (val >= 24) {
                throw new ParseException("invalid range format: " + range, 0);
            }
            time -= (long)val * MILLIS_IN_HOUR;
            val = Integer.parseInt(range.substring(5, 7));
            if (val >= 60) {
                throw new ParseException("invalid range format: " + range, 0);
            }
            time -= (long)val * MILLIS_IN_MIN;
            val = Integer.parseInt(range.substring(7, 9));
            if (val >= 60) {
                throw new ParseException("invalid range format: " + range, 0);
            }
            return time -= (long)val * MILLIS_IN_SEC;
        }
        catch (NumberFormatException e) {
            throw new ParseException("invalid time format:" + range, 0);
        }
    }

    private String buildRangeString(long currentTime, String dStart, String dEnd) throws ParseException {
        String end = this._formatter.get().format(DynamicTimeRangeFacetHandler.getTime(currentTime, dStart));
        String start = this._formatter.get().format(DynamicTimeRangeFacetHandler.getTime(currentTime, dEnd) + 1L);
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(start).append(" TO ").append(end).append("]");
        return buf.toString();
    }

    @Override
    protected String buildRangeString(String val) {
        return this._valueToRangeStringMap.get(val);
    }

    @Override
    protected List<String> buildAllRangeStrings() {
        return this._rangeStringList;
    }

    @Override
    protected String getValueFromRangeString(String val) {
        return this._rangeStringToValueMap.get(val);
    }

    public DynamicTimeRangeFacetHandler newInstance() {
        return new DynamicTimeRangeFacetHandler(this.getName(), this._dataFacetName, this._valueToRangeStringMap, this._rangeStringToValueMap, this._rangeStringList);
    }
}

