/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.KeyInfoContent;
import org.apache.xml.security.keys.content.x509.XMLX509CRL;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509Data
extends SignatureElementProxy
implements KeyInfoContent {
    static Log log = LogFactory.getLog((String)X509Data.class.getName());

    public X509Data(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public X509Data(Element element, String string) throws XMLSecurityException {
        super(element, string);
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) {
                continue;
            }
            return;
        }
        Object[] objectArray = new Object[]{"Elements", "X509Data"};
        throw new XMLSecurityException("xml.WrongContent", objectArray);
    }

    public void addIssuerSerial(String string, BigInteger bigInteger) {
        this.add(new XMLX509IssuerSerial(this._doc, string, bigInteger));
    }

    public void addIssuerSerial(String string, String string2) {
        this.add(new XMLX509IssuerSerial(this._doc, string, string2));
    }

    public void addIssuerSerial(String string, int n) {
        this.add(new XMLX509IssuerSerial(this._doc, string, n));
    }

    public void add(XMLX509IssuerSerial xMLX509IssuerSerial) {
        this._constructionElement.appendChild(xMLX509IssuerSerial.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addSKI(byte[] byArray) {
        this.add(new XMLX509SKI(this._doc, byArray));
    }

    public void addSKI(X509Certificate x509Certificate) throws XMLSecurityException {
        this.add(new XMLX509SKI(this._doc, x509Certificate));
    }

    public void add(XMLX509SKI xMLX509SKI) {
        this._constructionElement.appendChild(xMLX509SKI.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addSubjectName(String string) {
        this.add(new XMLX509SubjectName(this._doc, string));
    }

    public void addSubjectName(X509Certificate x509Certificate) {
        this.add(new XMLX509SubjectName(this._doc, x509Certificate));
    }

    public void add(XMLX509SubjectName xMLX509SubjectName) {
        this._constructionElement.appendChild(xMLX509SubjectName.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addCertificate(X509Certificate x509Certificate) throws XMLSecurityException {
        this.add(new XMLX509Certificate(this._doc, x509Certificate));
    }

    public void addCertificate(byte[] byArray) {
        this.add(new XMLX509Certificate(this._doc, byArray));
    }

    public void add(XMLX509Certificate xMLX509Certificate) {
        this._constructionElement.appendChild(xMLX509Certificate.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addCRL(byte[] byArray) {
        this.add(new XMLX509CRL(this._doc, byArray));
    }

    public void add(XMLX509CRL xMLX509CRL) {
        this._constructionElement.appendChild(xMLX509CRL.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addUnknownElement(Element element) {
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public int lengthIssuerSerial() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    }

    public int lengthSKI() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509SKI");
    }

    public int lengthSubjectName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509SubjectName");
    }

    public int lengthCertificate() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
    }

    public int lengthCRL() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509CRL");
    }

    public int lengthUnknownElement() {
        int n = 0;
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++n;
        }
        return n;
    }

    public XMLX509IssuerSerial itemIssuerSerial(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509IssuerSerial", n);
        if (element != null) {
            return new XMLX509IssuerSerial(element, this._baseURI);
        }
        return null;
    }

    public XMLX509SKI itemSKI(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509SKI", n);
        if (element != null) {
            return new XMLX509SKI(element, this._baseURI);
        }
        return null;
    }

    public XMLX509SubjectName itemSubjectName(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509SubjectName", n);
        if (element != null) {
            return new XMLX509SubjectName(element, this._baseURI);
        }
        return null;
    }

    public XMLX509Certificate itemCertificate(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509Certificate", n);
        if (element != null) {
            return new XMLX509Certificate(element, this._baseURI);
        }
        return null;
    }

    public XMLX509CRL itemCRL(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509CRL", n);
        if (element != null) {
            return new XMLX509CRL(element, this._baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int n) {
        log.debug((Object)("itemUnknownElement not implemented:" + n));
        return null;
    }

    public boolean containsIssuerSerial() {
        return this.lengthIssuerSerial() > 0;
    }

    public boolean containsSKI() {
        return this.lengthSKI() > 0;
    }

    public boolean containsSubjectName() {
        return this.lengthSubjectName() > 0;
    }

    public boolean containsCertificate() {
        return this.lengthCertificate() > 0;
    }

    public boolean containsCRL() {
        return this.lengthCRL() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public String getBaseLocalName() {
        return "X509Data";
    }
}

