/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.xmp.XmpDirectory;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpDescriptor
extends TagDescriptor<XmpDirectory> {
    @NotNull
    private static final DecimalFormat SimpleDecimalFormatter = new DecimalFormat("0.#");

    public XmpDescriptor(@NotNull XmpDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: 
            case 2: {
                return ((XmpDirectory)this._directory).getString(tagType);
            }
            case 3: {
                return this.getExposureTimeDescription();
            }
            case 12: {
                return this.getExposureProgramDescription();
            }
            case 4: {
                return this.getShutterSpeedDescription();
            }
            case 5: {
                return this.getFNumberDescription();
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ((XmpDirectory)this._directory).getString(tagType);
            }
            case 10: {
                return this.getFocalLengthDescription();
            }
            case 11: {
                return this.getApertureValueDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getExposureTimeDescription() {
        String value = ((XmpDirectory)this._directory).getString(3);
        if (value == null) {
            return null;
        }
        return value + " sec";
    }

    @Nullable
    public String getExposureProgramDescription() {
        Integer value = ((XmpDirectory)this._directory).getInteger(12);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Manual control";
            }
            case 2: {
                return "Program normal";
            }
            case 3: {
                return "Aperture priority";
            }
            case 4: {
                return "Shutter priority";
            }
            case 5: {
                return "Program creative (slow program)";
            }
            case 6: {
                return "Program action (high-speed program)";
            }
            case 7: {
                return "Portrait mode";
            }
            case 8: {
                return "Landscape mode";
            }
        }
        return "Unknown program (" + value + ")";
    }

    @Nullable
    public String getShutterSpeedDescription() {
        Float value = ((XmpDirectory)this._directory).getFloatObject(4);
        if (value == null) {
            return null;
        }
        if (value.floatValue() <= 1.0f) {
            float apexPower = (float)(1.0 / Math.exp((double)value.floatValue() * Math.log(2.0)));
            long apexPower10 = Math.round((double)apexPower * 10.0);
            float fApexPower = (float)apexPower10 / 10.0f;
            return fApexPower + " sec";
        }
        int apexPower = (int)Math.exp((double)value.floatValue() * Math.log(2.0));
        return "1/" + apexPower + " sec";
    }

    @Nullable
    public String getFNumberDescription() {
        Rational value = ((XmpDirectory)this._directory).getRational(5);
        if (value == null) {
            return null;
        }
        return "F" + SimpleDecimalFormatter.format(value.doubleValue());
    }

    @Nullable
    public String getFocalLengthDescription() {
        Rational value = ((XmpDirectory)this._directory).getRational(10);
        if (value == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        return formatter.format(value.doubleValue()) + " mm";
    }

    @Nullable
    public String getApertureValueDescription() {
        Double value = ((XmpDirectory)this._directory).getDoubleObject(11);
        if (value == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(value);
        return "F" + SimpleDecimalFormatter.format(fStop);
    }
}

