/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.AttributesOutputSegment;
import net.htmlparser.jericho.BlankOutputSegment;
import net.htmlparser.jericho.CharOutputSegment;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharStreamSourceUtil;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.OutputSegment;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.RemoveOutputSegment;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StringOutputSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutputDocument
implements CharStreamSource {
    private CharSequence sourceText;
    private ArrayList<OutputSegment> outputSegments = new ArrayList();

    public OutputDocument(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.sourceText = source;
    }

    public OutputDocument(Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException("segment argument must not be null");
        }
        Source source = segment.source;
        this.sourceText = source;
        if (segment.begin > 0) {
            this.remove(new Segment(source, 0, segment.begin));
        }
        if (segment.end < source.end) {
            this.remove(new Segment(source, segment.end, source.end));
        }
    }

    OutputDocument(ParseText parseText) {
        this.sourceText = parseText;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void remove(Segment segment) {
        this.register(new RemoveOutputSegment(segment));
    }

    public void remove(Collection<? extends Segment> collection) {
        for (Segment segment : collection) {
            this.remove(segment);
        }
    }

    public void insert(int n, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n, charSequence));
    }

    public void replace(Segment segment, CharSequence charSequence) {
        this.replace(segment.getBegin(), segment.getEnd(), charSequence);
    }

    public void replace(int n, int n2, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n2, charSequence));
    }

    public void replace(int n, int n2, char c) {
        this.register(new CharOutputSegment(n, n2, c));
    }

    public void replace(FormControl formControl) {
        formControl.replaceInOutputDocument(this);
    }

    public void replace(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public Map<String, String> replace(Attributes attributes, boolean bl) {
        AttributesOutputSegment attributesOutputSegment = new AttributesOutputSegment(attributes, bl);
        this.register(attributesOutputSegment);
        return attributesOutputSegment.getMap();
    }

    public void replace(Attributes attributes, Map<String, String> map) {
        this.register(new AttributesOutputSegment(attributes, map));
    }

    public void replaceWithSpaces(int n, int n2) {
        this.register(new BlankOutputSegment(n, n2));
    }

    public void register(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(Writer writer) throws IOException {
        try {
            this.appendTo(writer);
        }
        finally {
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer, int n, int n2) throws IOException {
        try {
            this.appendTo(writer, n, n2);
        }
        finally {
            writer.flush();
        }
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        this.appendTo(appendable, 0, this.sourceText.length());
    }

    public void appendTo(Appendable appendable, int n, int n2) throws IOException {
        if (this.outputSegments.isEmpty()) {
            appendable.append(this.sourceText, n, n2);
            return;
        }
        int n3 = n;
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        for (OutputSegment outputSegment : this.outputSegments) {
            if (outputSegment.getEnd() < n3 || outputSegment.getEnd() == n3 && outputSegment.getBegin() < n3) continue;
            if (outputSegment.getBegin() > n2 || outputSegment.getBegin() == n2 && outputSegment.getEnd() > n2) break;
            if (outputSegment.getBegin() > n3) {
                appendable.append(this.sourceText, n3, outputSegment.getBegin());
            }
            if (outputSegment.getBegin() < n3 && outputSegment instanceof BlankOutputSegment) {
                int n4 = outputSegment.getEnd();
                while (n3 < n4) {
                    appendable.append(' ');
                    ++n3;
                }
                continue;
            }
            outputSegment.appendTo(appendable);
            n3 = outputSegment.getEnd();
        }
        if (n3 < n2) {
            appendable.append(this.sourceText, n3, n2);
        }
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        long l = this.sourceText.length();
        for (OutputSegment outputSegment : this.outputSegments) {
            int n = outputSegment.getEnd() - outputSegment.getBegin();
            l += outputSegment.getEstimatedMaximumOutputLength() - (long)n;
        }
        return l >= 0L ? l : -1L;
    }

    @Override
    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (OutputSegment outputSegment : this.getRegisteredOutputSegments()) {
            CharSequence charSequence;
            if (outputSegment instanceof BlankOutputSegment) {
                stringBuilder.append("Replace with Spaces: ");
            } else if (outputSegment instanceof RemoveOutputSegment) {
                stringBuilder.append("Remove: ");
            } else {
                stringBuilder.append("Replace: ");
            }
            if (this.sourceText instanceof Source) {
                charSequence = (Source)this.sourceText;
                stringBuilder.append('(');
                ((Source)charSequence).getRowColumnVector(outputSegment.getBegin()).appendTo(stringBuilder);
                stringBuilder.append('-');
                ((Source)charSequence).getRowColumnVector(outputSegment.getEnd()).appendTo(stringBuilder);
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(p").append(outputSegment.getBegin()).append("-p").append(outputSegment.getEnd()).append(')');
            }
            stringBuilder.append(' ');
            charSequence = ((Object)outputSegment).toString();
            if (((String)charSequence).length() <= 20) {
                stringBuilder.append((String)charSequence);
            } else {
                stringBuilder.append(((String)charSequence).substring(0, 20)).append("...");
            }
            stringBuilder.append(Config.NewLine);
        }
        return stringBuilder.toString();
    }

    public List<OutputSegment> getRegisteredOutputSegments() {
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        return this.outputSegments;
    }
}

