/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sso.ntlm;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthSettingsUtil;
import com.liferay.portal.security.ntlm.NtlmManager;
import com.liferay.portal.security.ntlm.NtlmUserAccount;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.sso.ntlm.NtlmPostFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Config;
import jcifs.util.Base64;

public class NtlmFilter
extends BasePortalFilter {
    private static Log _log = LogFactoryUtil.getLog(NtlmFilter.class);
    private Map<Long, NtlmManager> _ntlmManagers = new ConcurrentHashMap<Long, NtlmManager>();
    private PortalCache<String, byte[]> _portalCache = SingleVMPoolUtil.getCache((String)NtlmFilter.class.getName());

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        try {
            Properties properties = PropsUtil.getProperties("jcifs.", false);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Config.setProperty((String)key, (String)value);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        try {
            long companyId = PortalInstances.getCompanyId(request);
            if (BrowserSnifferUtil.isIe((HttpServletRequest)request) && AuthSettingsUtil.isNtlmEnabled(companyId)) {
                return true;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return false;
    }

    @Override
    protected Log getLog() {
        return _log;
    }

    protected NtlmManager getNtlmManager(long companyId) throws SystemException {
        String domain = PrefsPropsUtil.getString(companyId, "ntlm.auth.domain", PropsValues.NTLM_DOMAIN);
        String domainController = PrefsPropsUtil.getString(companyId, "ntlm.auth.domain.controller", PropsValues.NTLM_DOMAIN_CONTROLLER);
        String domainControllerName = PrefsPropsUtil.getString(companyId, "ntlm.auth.domain.controller.name", PropsValues.NTLM_DOMAIN_CONTROLLER_NAME);
        String serviceAccount = PrefsPropsUtil.getString(companyId, "ntlm.auth.service.account", PropsValues.NTLM_SERVICE_ACCOUNT);
        String servicePassword = PrefsPropsUtil.getString(companyId, "ntlm.auth.service.password", PropsValues.NTLM_SERVICE_PASSWORD);
        NtlmManager ntlmManager = this._ntlmManagers.get(companyId);
        if (ntlmManager == null) {
            ntlmManager = new NtlmManager(domain, domainController, domainControllerName, serviceAccount, servicePassword);
            this._ntlmManagers.put(companyId, ntlmManager);
        } else if (!(Validator.equals((Object)ntlmManager.getDomain(), (Object)domain) && Validator.equals((Object)ntlmManager.getDomainController(), (Object)domainController) && Validator.equals((Object)ntlmManager.getDomainControllerName(), (Object)domainControllerName) && Validator.equals((Object)ntlmManager.getServiceAccount(), (Object)serviceAccount) && Validator.equals((Object)ntlmManager.getServicePassword(), (Object)servicePassword))) {
            ntlmManager.setConfiguration(domain, domainController, domainControllerName, serviceAccount, servicePassword);
        }
        return ntlmManager;
    }

    protected String getPortalCacheKey(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return request.getRemoteAddr();
        }
        return session.getId();
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String path;
        HttpSession session = request.getSession(false);
        long companyId = PortalInstances.getCompanyId(request);
        String authorization = GetterUtil.getString((String)request.getHeader("Authorization"));
        if (authorization.startsWith("NTLM")) {
            NtlmUserAccount ntlmUserAccount;
            block15: {
                NtlmManager ntlmManager = this.getNtlmManager(companyId);
                String portalCacheKey = this.getPortalCacheKey(request);
                byte[] src = Base64.decode((String)authorization.substring(5));
                if (src[8] == 1) {
                    byte[] serverChallenge = new byte[8];
                    BigEndianCodec.putLong((byte[])serverChallenge, (int)0, (long)SecureRandomUtil.nextLong());
                    byte[] challengeMessage = ntlmManager.negotiate(src, serverChallenge);
                    authorization = Base64.encode((byte[])challengeMessage);
                    response.setContentLength(0);
                    response.setHeader("WWW-Authenticate", "NTLM " + authorization);
                    response.setStatus(401);
                    response.flushBuffer();
                    this._portalCache.put((Serializable)((Object)portalCacheKey), (Object)serverChallenge);
                    return;
                }
                byte[] serverChallenge = (byte[])this._portalCache.get((Serializable)((Object)portalCacheKey));
                if (serverChallenge == null) {
                    response.setContentLength(0);
                    response.setHeader("WWW-Authenticate", "NTLM");
                    response.setStatus(401);
                    response.flushBuffer();
                    return;
                }
                ntlmUserAccount = null;
                try {
                    try {
                        ntlmUserAccount = ntlmManager.authenticate(src, serverChallenge);
                    }
                    catch (Exception e2) {
                        if (_log.isErrorEnabled()) {
                            _log.error((Object)"Unable to perform NTLM authentication", (Throwable)e2);
                        }
                        this._portalCache.remove((Serializable)((Object)portalCacheKey));
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    this._portalCache.remove((Serializable)((Object)portalCacheKey));
                    throw throwable;
                }
                this._portalCache.remove((Serializable)((Object)portalCacheKey));
            }
            if (ntlmUserAccount == null) {
                response.setContentLength(0);
                response.setHeader("WWW-Authenticate", "NTLM");
                response.setStatus(401);
                response.flushBuffer();
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("NTLM remote user " + ntlmUserAccount.getUserName()));
            }
            request.setAttribute("NTLM_REMOTE_USER", (Object)ntlmUserAccount.getUserName());
            if (session != null) {
                session.setAttribute("NTLM_USER_ACCOUNT", (Object)ntlmUserAccount);
            }
        }
        if ((path = request.getPathInfo()) != null && path.endsWith("/login")) {
            NtlmUserAccount ntlmUserAccount = null;
            if (session != null) {
                ntlmUserAccount = (NtlmUserAccount)session.getAttribute("NTLM_USER_ACCOUNT");
            }
            if (ntlmUserAccount == null) {
                response.setContentLength(0);
                response.setHeader("WWW-Authenticate", "NTLM");
                response.setStatus(401);
                response.flushBuffer();
                return;
            }
            request.setAttribute("NTLM_REMOTE_USER", (Object)ntlmUserAccount.getUserName());
        }
        this.processFilter(NtlmPostFilter.class, request, response, filterChain);
    }
}

