/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.portletbridge.PortletBridgeException;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.BridgeFunctions;
import org.portletbridge.portlet.BridgeFunctionsFactory;
import org.portletbridge.portlet.BridgeRequest;
import org.portletbridge.portlet.DefaultHttpClientTemplate;
import org.portletbridge.portlet.DefaultIdGenerator;
import org.portletbridge.portlet.DefaultPortletBridgeService;
import org.portletbridge.portlet.HttpClientCallback;
import org.portletbridge.portlet.HttpClientTemplate;
import org.portletbridge.portlet.PerPortletMemento;
import org.portletbridge.portlet.PortletBridgeContent;
import org.portletbridge.portlet.PortletBridgeMemento;
import org.portletbridge.portlet.PortletBridgeService;
import org.portletbridge.portlet.PseudoRenderRequest;
import org.portletbridge.portlet.PseudoRenderResponse;
import org.portletbridge.portlet.RegexContentRewriter;
import org.portletbridge.portlet.ResourceUtil;

public class PortletBridgeServlet
extends HttpServlet {
    private static final long serialVersionUID = 7841139248662925798L;
    public static final ResourceBundle resourceBundle = PropertyResourceBundle.getBundle("org.portletbridge.portlet.PortletBridgePortlet");
    private static final Log log = LogFactory.getLog((Class)(class$org$portletbridge$portlet$PortletBridgeServlet == null ? (class$org$portletbridge$portlet$PortletBridgeServlet = PortletBridgeServlet.class$("org.portletbridge.portlet.PortletBridgeServlet")) : class$org$portletbridge$portlet$PortletBridgeServlet));
    private PortletBridgeService portletBridgeService = new DefaultPortletBridgeService();
    private HttpClientTemplate httpClientTemplate = new DefaultHttpClientTemplate();
    private String mementoSessionKey;
    private BridgeFunctionsFactory bridgeFunctionsFactory;
    private Set ignoreRequestHeaders;
    private Set ignorePostToGetRequestHeaders;
    static /* synthetic */ Class class$org$portletbridge$portlet$PortletBridgeServlet;

    public void init() throws ServletException {
        this.mementoSessionKey = this.getServletConfig().getInitParameter("mementoSessionKey");
        log.debug((Object)("init(): mementoSessionKey=" + this.mementoSessionKey));
        if (this.mementoSessionKey == null) {
            throw new ServletException(resourceBundle.getString("error.mementoSessionKey"));
        }
        String cssRegex = this.getServletConfig().getInitParameter("cssRegex");
        String javascriptRegex = this.getServletConfig().getInitParameter("jsRegex");
        RegexContentRewriter javascriptRewriter = new RegexContentRewriter(javascriptRegex);
        RegexContentRewriter cssRewriter = new RegexContentRewriter(cssRegex);
        this.bridgeFunctionsFactory = new BridgeFunctionsFactory(DefaultIdGenerator.getInstance(), javascriptRewriter, cssRewriter);
        this.ignoreRequestHeaders = new HashSet<String>(Arrays.asList(this.getInitParameter("ignoreRequestHeaders").split(",")));
        this.ignorePostToGetRequestHeaders = new HashSet<String>(Arrays.asList(this.getInitParameter("ignorePostToGetRequestHeaders").split(",")));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = this.portletBridgeService.getIdFromRequestUri(request.getContextPath(), request.getRequestURI());
        HttpSession session = request.getSession();
        if (session == null) {
            throw new ServletException(resourceBundle.getString("error.nosession") + ", URL=" + request.getRequestURI());
        }
        PortletBridgeMemento memento = (PortletBridgeMemento)session.getAttribute(this.mementoSessionKey);
        if (memento == null) {
            throw new ServletException(resourceBundle.getString("error.nomemento") + ", URL=" + request.getRequestURI());
        }
        BridgeRequest bridgeRequest = memento.getBridgeRequest(id);
        if (bridgeRequest == null) {
            throw new ServletException(resourceBundle.getString("error.nobridgerequest") + ", URL=" + request.getRequestURI());
        }
        PerPortletMemento perPortletMemento = memento.getPerPortletMemento(bridgeRequest.getPortletId());
        if (perPortletMemento == null) {
            throw new ServletException(resourceBundle.getString("error.noperportletmemento") + ", URL=" + request.getRequestURI());
        }
        java.net.URI url = bridgeRequest.getUrl();
        if (request.getQueryString() != null && request.getQueryString().trim().length() > 0) {
            try {
                String urlAsString = url.toString();
                url = new java.net.URI(urlAsString + (url.getQuery() != null ? (char)'&' : '?') + request.getQueryString());
                PseudoRenderResponse renderResponse = this.createRenderResponse(bridgeRequest);
                bridgeRequest = memento.createBridgeRequest(renderResponse, DefaultIdGenerator.getInstance().nextId(), url);
            }
            catch (URISyntaxException e) {
                throw new ServletException(e.getMessage() + ", doGet(): URL=" + url + ", id=" + id + ", request URI=" + request.getRequestURI(), (Throwable)e);
            }
        }
        log.debug((Object)("doGet(): URL=" + url + ", id=" + id + ", request URI=" + request.getRequestURI()));
        this.fetch(request, response, bridgeRequest, memento, perPortletMemento, url);
    }

    protected PseudoRenderResponse createRenderResponse(BridgeRequest bridgeRequest) {
        PseudoRenderResponse renderResponse = new PseudoRenderResponse(bridgeRequest.getPortletId(), bridgeRequest.getPageUrl(), bridgeRequest.getId());
        return renderResponse;
    }

    protected void fetch(final HttpServletRequest request, final HttpServletResponse response, final BridgeRequest bridgeRequest, final PortletBridgeMemento memento, final PerPortletMemento perPortletMemento, final java.net.URI url) throws ServletException {
        try {
            GetMethod getMethod = new GetMethod(url.toString());
            this.copyRequestHeaders(request, (HttpMethodBase)getMethod);
            this.httpClientTemplate.service((HttpMethodBase)getMethod, perPortletMemento, new HttpClientCallback(){

                public Object doInHttpClient(int statusCode, HttpMethodBase method) throws ResourceException, Throwable {
                    if (statusCode == 200) {
                        URI effectiveUri = method.getURI();
                        BridgeRequest effectiveBridgeRequest = null;
                        if (!effectiveUri.toString().equals(url.toString())) {
                            PseudoRenderResponse renderResponse = PortletBridgeServlet.this.createRenderResponse(bridgeRequest);
                            effectiveBridgeRequest = memento.createBridgeRequest(renderResponse, DefaultIdGenerator.getInstance().nextId(), new java.net.URI(effectiveUri.toString()));
                        } else {
                            effectiveBridgeRequest = bridgeRequest;
                        }
                        Header responseHeader = method.getResponseHeader("Content-Type");
                        if (responseHeader != null && responseHeader.getValue().startsWith("text/html")) {
                            String content = ResourceUtil.getString(method.getResponseBodyAsStream(), method.getResponseCharSet());
                            perPortletMemento.enqueueContent(effectiveBridgeRequest.getId(), new PortletBridgeContent(url, "get", content));
                            response.sendRedirect(effectiveBridgeRequest.getPageUrl());
                        } else if (responseHeader != null && responseHeader.getValue().startsWith("text/javascript")) {
                            String content = ResourceUtil.getString(method.getResponseBodyAsStream(), method.getResponseCharSet());
                            BridgeFunctions bridge = PortletBridgeServlet.this.bridgeFunctionsFactory.createBridgeFunctions(memento, perPortletMemento, PortletBridgeServlet.this.getServletName(), url, new PseudoRenderRequest(request.getContextPath()), PortletBridgeServlet.this.createRenderResponse(effectiveBridgeRequest));
                            response.setContentType("text/javascript");
                            PrintWriter writer = response.getWriter();
                            writer.write(bridge.script(null, content));
                            writer.flush();
                        } else if (responseHeader != null && responseHeader.getValue().startsWith("text/css")) {
                            String content = ResourceUtil.getString(method.getResponseBodyAsStream(), method.getResponseCharSet());
                            BridgeFunctions bridge = PortletBridgeServlet.this.bridgeFunctionsFactory.createBridgeFunctions(memento, perPortletMemento, PortletBridgeServlet.this.getServletName(), url, new PseudoRenderRequest(request.getContextPath()), PortletBridgeServlet.this.createRenderResponse(effectiveBridgeRequest));
                            response.setContentType("text/css");
                            PrintWriter writer = response.getWriter();
                            writer.write(bridge.style(null, content));
                            writer.flush();
                        } else {
                            Header header = method.getResponseHeader("Content-Type");
                            response.setContentType((null == header.getName() ? "" : header.getName()) + ": " + (null == header.getValue() ? "" : header.getValue()));
                            log.trace((Object)("fetch(): returning URL=" + url + ", as stream, content type=" + header));
                            ResourceUtil.copy(method.getResponseBodyAsStream(), (OutputStream)response.getOutputStream(), 4096);
                        }
                    } else {
                        response.sendError(statusCode);
                    }
                    return null;
                }
            });
        }
        catch (ResourceException resourceException) {
            String format = MessageFormat.format(resourceBundle.getString(resourceException.getMessage()), resourceException.getArgs());
            throw new ServletException(format, (Throwable)resourceException);
        }
    }

    protected void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        String id = this.portletBridgeService.getIdFromRequestUri(request.getContextPath(), request.getRequestURI());
        HttpSession session = request.getSession();
        if (session == null) {
            throw new ServletException(resourceBundle.getString("error.nosession"));
        }
        final PortletBridgeMemento memento = (PortletBridgeMemento)session.getAttribute(this.mementoSessionKey);
        if (memento == null) {
            throw new ServletException(resourceBundle.getString("error.nomemento"));
        }
        final BridgeRequest bridgeRequest = memento.getBridgeRequest(id);
        if (bridgeRequest == null) {
            throw new ServletException(resourceBundle.getString("error.nobridgerequest"));
        }
        final PerPortletMemento perPortletMemento = memento.getPerPortletMemento(bridgeRequest.getPortletId());
        if (perPortletMemento == null) {
            throw new ServletException(resourceBundle.getString("error.noperportletmemento"));
        }
        final java.net.URI url = bridgeRequest.getUrl();
        log.debug((Object)("doPost(): URL=" + url));
        try {
            PostMethod postMethod = new PostMethod(url.toString());
            this.copyRequestHeaders(request, (HttpMethodBase)postMethod);
            postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)request.getInputStream()));
            this.httpClientTemplate.service((HttpMethodBase)postMethod, perPortletMemento, new HttpClientCallback(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object doInHttpClient(int statusCode, HttpMethodBase method) throws ResourceException, Throwable {
                    if (statusCode == 200) {
                        Header responseHeader = method.getResponseHeader("Content-Type");
                        if (responseHeader != null && responseHeader.getValue().startsWith("text/html")) {
                            String content = ResourceUtil.getString(method.getResponseBodyAsStream(), method.getResponseCharSet());
                            perPortletMemento.enqueueContent(bridgeRequest.getId(), new PortletBridgeContent(url, "post", content));
                            log.debug((Object)("doPost(): doing response.sendRedirect to URL=" + bridgeRequest.getPageUrl()));
                            response.sendRedirect(bridgeRequest.getPageUrl());
                            return null;
                        } else {
                            response.setContentType(method.getResponseHeader("Content-Type").toExternalForm());
                            ResourceUtil.copy(method.getResponseBodyAsStream(), (OutputStream)response.getOutputStream(), 4096);
                        }
                        return null;
                    } else if (statusCode == 302) {
                        Header locationHeader = method.getResponseHeader("Location");
                        if (locationHeader == null) throw new PortletBridgeException("error.missingLocation");
                        java.net.URI redirectUrl = new java.net.URI(locationHeader.getValue().trim());
                        log.debug((Object)("redirecting to [" + redirectUrl + "]"));
                        PseudoRenderResponse renderResponse = PortletBridgeServlet.this.createRenderResponse(bridgeRequest);
                        BridgeRequest updatedBridgeRequest = memento.createBridgeRequest(renderResponse, DefaultIdGenerator.getInstance().nextId(), redirectUrl);
                        PortletBridgeServlet.this.fetch(request, response, updatedBridgeRequest, memento, perPortletMemento, redirectUrl);
                        return null;
                    } else {
                        response.sendError(statusCode);
                    }
                    return null;
                }
            });
        }
        catch (ResourceException resourceException) {
            String format = MessageFormat.format(resourceBundle.getString(resourceException.getMessage()), resourceException.getArgs());
            throw new ServletException(format, (Throwable)resourceException);
        }
    }

    public void setPortletBridgeService(PortletBridgeService portletBridgeService) {
        this.portletBridgeService = portletBridgeService;
    }

    public void setHttpClientTemplate(HttpClientTemplate httpClientTemplate) {
        this.httpClientTemplate = httpClientTemplate;
    }

    protected void copyRequestHeaders(HttpServletRequest request, HttpMethodBase method) {
        Enumeration properties = request.getHeaderNames();
        while (properties.hasMoreElements()) {
            String propertyName = (String)properties.nextElement();
            String propertyNameToLower = propertyName.toLowerCase();
            if (this.ignoreRequestHeaders.contains(propertyNameToLower) || method instanceof GetMethod && this.ignorePostToGetRequestHeaders.contains(propertyNameToLower)) continue;
            Enumeration values = request.getHeaders(propertyName);
            while (values.hasMoreElements()) {
                String property = (String)values.nextElement();
                method.setRequestHeader(propertyName, property);
            }
        }
        try {
            String cookie;
            if (method.getURI().getHost().equals(request.getHeader("host")) && (cookie = request.getHeader("cookie")) != null) {
                method.setRequestHeader("cookie", cookie);
            }
        }
        catch (URIException e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

