/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.buffer;

public class FastCharBuffer
implements CharSequence,
Appendable {
    private char[][] buffers = new char[16][];
    private int buffersCount;
    private int currentBufferIndex = -1;
    private char[] currentBuffer;
    private int offset;
    private int count;

    public FastCharBuffer() {
        this(1024);
    }

    public FastCharBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.needNewBuffer(size);
    }

    private void needNewBuffer(int newCount) {
        if (this.currentBufferIndex < this.buffersCount - 1) {
            this.offset = 0;
            ++this.currentBufferIndex;
            this.currentBuffer = this.buffers[this.currentBufferIndex];
        } else {
            int newBufferSize = this.currentBuffer == null ? newCount : Math.max(this.currentBuffer.length << 1, newCount - this.count);
            ++this.currentBufferIndex;
            this.currentBuffer = new char[newBufferSize];
            this.offset = 0;
            if (this.currentBufferIndex >= this.buffers.length) {
                int newLen = this.buffers.length << 1;
                char[][] newBuffers = new char[newLen][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            this.buffers[this.currentBufferIndex] = this.currentBuffer;
            ++this.buffersCount;
        }
    }

    public FastCharBuffer append(char[] array, int off, int len) {
        int end = off + len;
        if (off < 0 || off > array.length || len < 0 || end > array.length || end < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        int remaining = len;
        while (remaining > 0) {
            int part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.count += part;
            if ((remaining -= part) <= 0) continue;
            this.needNewBuffer(newCount);
        }
        return this;
    }

    public FastCharBuffer append(char[] array) {
        return this.append(array, 0, array.length);
    }

    public FastCharBuffer append(char element) {
        if (this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
        }
        this.currentBuffer[this.offset] = element;
        ++this.offset;
        ++this.count;
        return this;
    }

    public FastCharBuffer append(FastCharBuffer buff) {
        for (int i = 0; i < buff.currentBufferIndex; ++i) {
            this.append(buff.buffers[i]);
        }
        this.append(buff.currentBuffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public char[] array(int index) {
        return this.buffers[index];
    }

    public void clear() {
        this.count = 0;
        this.offset = 0;
        this.currentBufferIndex = 0;
        this.currentBuffer = this.buffers[this.currentBufferIndex];
        this.buffersCount = 1;
    }

    public char[] toArray() {
        int remaining = this.count;
        int pos = 0;
        char[] array = new char[this.count];
        for (char[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
        }
        return array;
    }

    public char[] toArray(int start, int len) {
        int remaining = len;
        int pos = 0;
        char[] array = new char[len];
        if (len == 0) {
            return array;
        }
        int i = 0;
        while (start >= this.buffers[i].length) {
            start -= this.buffers[i].length;
            ++i;
        }
        while (i < this.buffersCount) {
            char[] buf = this.buffers[i];
            int c = Math.min(buf.length - start, remaining);
            System.arraycopy(buf, start, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
            start = 0;
            ++i;
        }
        return array;
    }

    public char get(int index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        char[] b;
        while (index >= (b = this.buffers[ndx]).length) {
            ++ndx;
            index -= b.length;
        }
        return b[index];
    }

    public int length() {
        return this.count;
    }

    public String toString() {
        return new String(this.toArray());
    }

    public char charAt(int index) {
        return this.get(index);
    }

    public CharSequence subSequence(int start, int end) {
        int len = end - start;
        return new StringBuilder(len).append(this.toArray(start, len));
    }

    public FastCharBuffer append(String string) {
        return this.append(string.toCharArray());
    }

    public FastCharBuffer append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    public FastCharBuffer append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }
}

