/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Method;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Methods;
import jodd.util.ReflectUtil;

class Properties {
    private final Methods getters;
    private String[] getterNames;
    private final Methods setters;
    private String[] setterNames;

    Properties(ClassDescriptor classDescriptor) {
        this.getters = new Methods(classDescriptor, 0);
        this.setters = new Methods(classDescriptor, 0);
    }

    void addMethod(String name, Method method) {
        this.getterNames = null;
        this.setterNames = null;
        if (name.charAt(0) == '-') {
            Method existingMethod = this.getters.getMethod(name = name.substring(1), ReflectUtil.NO_PARAMETERS);
            if (existingMethod != null) {
                String methodName = method.getName();
                String existingMethodName = existingMethod.getName();
                if (existingMethodName.startsWith("get") && methodName.startsWith("is")) {
                    this.getters.removeMethods(name);
                } else if (existingMethodName.startsWith("is") && methodName.startsWith("get")) {
                    return;
                }
            }
            this.getters.addMethod(name, method);
        } else if (name.charAt(0) == '+') {
            name = name.substring(1);
            this.setters.addMethod(name, method);
        } else {
            throw new IllegalArgumentException();
        }
    }

    Methods getGetters() {
        return this.getters;
    }

    String[] getGetterNames() {
        if (this.getterNames == null) {
            Method[] getterMethods = this.getters.getAllMethods();
            String[] names = new String[getterMethods.length];
            for (int i = 0; i < getterMethods.length; ++i) {
                names[i] = ReflectUtil.getBeanPropertyGetterName(getterMethods[i]);
            }
            this.getterNames = names;
        }
        return this.getterNames;
    }

    Methods getSetters() {
        return this.setters;
    }

    String[] getSetterNames() {
        if (this.setterNames == null) {
            Method[] setterMethods = this.setters.getAllMethods();
            String[] names = new String[setterMethods.length];
            for (int i = 0; i < setterMethods.length; ++i) {
                names[i] = ReflectUtil.getBeanPropertySetterName(setterMethods[i]);
            }
            this.setterNames = names;
        }
        return this.setterNames;
    }
}

