/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import org.apache.jackrabbit.core.cache.CacheManager;
import org.apache.jackrabbit.core.cache.ConcurrentCache;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLRUItemStateCache
implements ItemStateCache {
    private static Logger log = LoggerFactory.getLogger(MLRUItemStateCache.class);
    public static final int DEFAULT_MAX_MEM = 0x400000;
    private volatile long numWrites = 0L;
    private final ConcurrentCache<ItemId, ItemState> cache = new ConcurrentCache();

    public MLRUItemStateCache(CacheManager cacheMgr) {
        this.cache.setMaxMemorySize(0x400000L);
        this.cache.setAccessListener(cacheMgr);
        cacheMgr.add(this.cache);
    }

    public boolean isCached(ItemId id) {
        return this.cache.containsKey(id);
    }

    public ItemState retrieve(ItemId id) {
        return this.cache.get(id);
    }

    public ItemState[] retrieveAll() {
        return this.cache.values();
    }

    public void cache(ItemState state) {
        this.cache.put(state.getId(), state, state.calculateMemoryFootprint());
        if (this.numWrites++ % 10000L == 0L && log.isDebugEnabled()) {
            log.debug("Item state cache size: {}% of {} bytes", (Object)(this.cache.getMemoryUsed() * 100L / this.cache.getMaxMemorySize()), (Object)this.cache.getMaxMemorySize());
        }
    }

    public void evict(ItemId id) {
        this.cache.remove(id);
    }

    public void evictAll() {
        this.cache.clear();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void dispose() {
        this.cache.dispose();
    }
}

