/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.model.ResourcePermission;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeAdminPortlets
extends UpgradeProcess {
    protected void addResourcePermission(long resourcePermissionId, long companyId, String name, int scope, String primKey, long roleId, long actionIds) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("insert into ResourcePermission (resourcePermissionId, companyId, name, scope, primKey, roleId, actionIds) values (?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, resourcePermissionId);
            ps.setLong(2, companyId);
            ps.setString(3, name);
            ps.setInt(4, scope);
            ps.setString(5, primKey);
            ps.setLong(6, roleId);
            ps.setLong(7, actionIds);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        this.updateAccessInControlPanelPermission("33", "161");
        this.updateAccessInControlPanelPermission("19", "162");
    }

    protected long getBitwiseValue(String name, String actionId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select bitwiseValue from ResourceAction where name = ? and actionId = ?");
                ps.setString(1, name);
                ps.setString(2, actionId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("bitwiseValue");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected long getControlPanelGroupId() throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select groupId from Group_ where name = 'Control Panel'");
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("groupId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected void updateAccessInControlPanelPermission(String portletFrom, String portletTo) throws Exception {
        long bitwiseValue = this.getBitwiseValue(portletFrom, "ACCESS_IN_CONTROL_PANEL");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from ResourcePermission where name = ?");
            ps.setString(1, portletFrom);
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourcePermissionId = rs.getLong("resourcePermissionId");
                long actionIds = rs.getLong("actionIds");
                if ((actionIds & bitwiseValue) == 0L) continue;
                this.runSQL("update ResourcePermission set actionIds = " + (actionIds &= bitwiseValue ^ 0xFFFFFFFFFFFFFFFFL) + " where resourcePermissionId = " + resourcePermissionId);
                resourcePermissionId = this.increment(ResourcePermission.class.getName());
                long companyId = rs.getLong("companyId");
                int scope = rs.getInt("scope");
                String primKey = rs.getString("primKey");
                long roleId = rs.getLong("roleId");
                actionIds = rs.getLong("actionIds");
                this.addResourcePermission(resourcePermissionId, companyId, portletTo, scope, primKey, roleId, actionIds |= bitwiseValue);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

