/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.agent;

import com.liferay.portal.kernel.resiliency.PortalResiliencyException;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.resiliency.spi.agent.SPIAgentRequest;
import com.liferay.portal.resiliency.spi.agent.SPIAgentSerializable;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SPIAgentResponse
extends SPIAgentSerializable {
    protected byte[] byteData;
    protected Map<String, Serializable> deltaSessionAttributes;
    protected Map<String, Serializable> distributedRequestAttributes;
    protected Exception exception;
    protected MetaInfoCacheServletResponse.MetaData metaData;
    protected boolean portalResiliencyResponse;
    protected String stringData;

    public SPIAgentResponse(String servletContextName) {
        super(servletContextName);
    }

    public void captureRequestSessionAttributes(HttpServletRequest request) {
        this.distributedRequestAttributes = SPIAgentResponse.extractDistributedRequestAttributes(request, Direction.RESPONSE);
        SPIAgentRequest spiAgentRequest = (SPIAgentRequest)request.getAttribute("SPI_AGENT_REQUEST");
        Map<String, Serializable> originalSessionAttributes = spiAgentRequest.getOriginalSessionAttributes();
        Map<String, Serializable> newSessionAttributes = SPIAgentResponse.extractSessionAttributes(request);
        Set<String> removedSessionAttributeNames = originalSessionAttributes.keySet();
        removedSessionAttributeNames.removeAll(newSessionAttributes.keySet());
        this.deltaSessionAttributes = new HashMap<String, Serializable>(newSessionAttributes);
        for (String removedSessionAttributeName : removedSessionAttributeNames) {
            this.deltaSessionAttributes.put(removedSessionAttributeName, null);
        }
        this.captureThreadLocals();
    }

    public void captureResponse(HttpServletRequest request, BufferCacheServletResponse bufferCacheServletResponse) throws IOException {
        int index;
        ByteBuffer byteBuffer;
        Boolean portalResiliencyAction = (Boolean)request.getAttribute("PORTAL_RESILIENCY_ACTION");
        if (portalResiliencyAction != Boolean.TRUE) {
            this.portalResiliencyResponse = false;
            return;
        }
        this.portalResiliencyResponse = true;
        this.metaData = bufferCacheServletResponse.getMetaData();
        this.byteData = null;
        if (bufferCacheServletResponse.isByteMode() && (byteBuffer = bufferCacheServletResponse.getByteBuffer()).remaining() > 0) {
            if (byteBuffer.hasArray()) {
                byte[] byteArray = byteBuffer.array();
                if (byteBuffer.remaining() == byteArray.length) {
                    this.byteData = byteArray;
                }
            }
            if (this.byteData == null) {
                this.byteData = new byte[byteBuffer.remaining()];
                byteBuffer.get(this.byteData);
            }
        }
        this.stringData = null;
        if (!bufferCacheServletResponse.isCharMode()) {
            return;
        }
        String content = bufferCacheServletResponse.getString();
        if (content.length() == 0) {
            return;
        }
        if (ParamUtil.get((HttpServletRequest)request, (String)"portalResiliencyPortletShowFooter", (boolean)PropsValues.PORTAL_RESILIENCY_PORTLET_SHOW_FOOTER) && (index = content.lastIndexOf("</div>")) > 0) {
            StringBundler sb = new StringBundler(6);
            sb.append(content.substring(0, index));
            sb.append("<div class=\"alert alert-info\"><strong>");
            sb.append("This portlet is from SPI ");
            sb.append(PortalUtil.getPortalPort((boolean)false));
            sb.append("</strong></div>");
            sb.append(content.substring(index));
            content = sb.toString();
        }
        this.stringData = content;
    }

    public void populate(HttpServletRequest request, HttpServletResponse response) throws PortalResiliencyException {
        if (this.exception != null) {
            throw new PortalResiliencyException("SPI exception", (Throwable)this.exception);
        }
        if (!this.portalResiliencyResponse) {
            return;
        }
        String typeSettings = (String)((Object)this.distributedRequestAttributes.remove("SPI_AGENT_LAYOUT_TYPE_SETTINGS"));
        if (typeSettings != null) {
            Layout layout = (Layout)request.getAttribute("LAYOUT");
            layout.setTypeSettings(typeSettings);
        }
        for (Map.Entry<String, Serializable> entry : this.distributedRequestAttributes.entrySet()) {
            request.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
        HttpSession session = request.getSession();
        for (Map.Entry<String, Serializable> entry : this.deltaSessionAttributes.entrySet()) {
            session.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
        try {
            MetaInfoCacheServletResponse.finishResponse((MetaInfoCacheServletResponse.MetaData)this.metaData, (HttpServletResponse)response);
            if (this.byteData != null) {
                ServletResponseUtil.write((HttpServletResponse)response, (ByteBuffer)ByteBuffer.wrap(this.byteData));
            }
            if (this.stringData != null) {
                ServletResponseUtil.write((HttpServletResponse)response, (CharBuffer)CharBuffer.wrap(this.stringData));
            }
        }
        catch (IOException ioe) {
            throw new PortalResiliencyException((Throwable)ioe);
        }
        this.restoreThreadLocals();
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }
}

