/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;

public class TriggerDefSQL
extends TriggerDef {
    OrderedHashSet references;

    public TriggerDefSQL(HsqlNameManager.HsqlName name, int when, int operation, boolean forEachRow, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns, Routine routine) {
        super(name, when, operation, forEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumns);
        this.routine = routine;
        this.references = routine.getReferences();
    }

    public OrderedHashSet getReferences() {
        return this.routine.getReferences();
    }

    public OrderedHashSet getComponents() {
        return null;
    }

    public void compile(Session session, SchemaObject parentObject) {
    }

    public String getClassName() {
        return null;
    }

    public boolean hasOldTable() {
        return this.transitions[2] != null;
    }

    public boolean hasNewTable() {
        return this.transitions[3] != null;
    }

    synchronized void pushPair(Session session, Object[] oldData, Object[] newData) {
        Result result = Result.updateZeroResult;
        session.sessionContext.push();
        if (this.rangeVars[0] != null || this.rangeVars[1] != null) {
            session.sessionContext.triggerArguments = new Object[][]{oldData, newData};
        }
        if (this.condition.testCondition(session)) {
            int variableCount = this.routine.getVariableCount();
            session.sessionContext.routineVariables = new Object[variableCount];
            result = this.routine.statement.execute(session);
        }
        session.sessionContext.pop();
        if (result.isError()) {
            throw result.getException();
        }
    }

    public String getSQL() {
        StringBuffer sb = this.getSQLMain();
        sb.append(this.routine.statement.getSQL());
        return sb.toString();
    }
}

