/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.persistence.BasePersistence;
import com.liferay.portal.service.persistence.impl.ReverseTableMapper;
import com.liferay.portal.service.persistence.impl.TableMapper;
import com.liferay.portal.service.persistence.impl.TableMapperImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TableMapperFactory {
    protected static Map<String, TableMapper<?, ?>> tableMappers = new ConcurrentHashMap();

    public static <L extends BaseModel<L>, R extends BaseModel<R>> TableMapper<L, R> getTableMapper(String tableName, String leftColumnName, String rightColumnName, BasePersistence<L> leftPersistence, BasePersistence<R> rightPersistence) {
        TableMapper<?, ?> tableMapper = tableMappers.get(tableName);
        if (tableMapper == null) {
            TableMapperImpl tableMapperImpl = new TableMapperImpl(tableName, leftColumnName, rightColumnName, leftPersistence, rightPersistence);
            tableMapperImpl.setReverseTableMapper(new ReverseTableMapper<R, L>(tableMapperImpl));
            tableMapper = tableMapperImpl;
            tableMappers.put(tableName, tableMapper);
        } else if (!tableMapper.matches(leftColumnName, rightColumnName)) {
            tableMapper = tableMapper.getReverseTableMapper();
        }
        return tableMapper;
    }

    public static void removeTableMapper(String tableName) {
        TableMapper<?, ?> tableMapper = tableMappers.remove(tableName);
        if (tableMapper != null) {
            tableMapper.destroy();
        }
    }
}

