/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet.util;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FacetFactoryUtil {
    private static Map<String, Constructor<?>> _constructorCache = new ConcurrentHashMap();

    public static Facet create(SearchContext searchContext, FacetConfiguration facetConfiguration) throws Exception {
        String className = facetConfiguration.getClassName();
        Constructor<?> constructor = _constructorCache.get(className);
        if (constructor == null) {
            constructor = Class.forName(className).getConstructor(SearchContext.class);
            _constructorCache.put(className, constructor);
        }
        Facet facet = (Facet)constructor.newInstance(searchContext);
        facet.setFacetConfiguration(facetConfiguration);
        return facet;
    }
}

