/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseAsyncDestination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import java.util.Set;

public class ParallelDestination
extends BaseAsyncDestination {
    private static Log _log = LogFactoryUtil.getLog(ParallelDestination.class);

    public ParallelDestination() {
    }

    public ParallelDestination(String name) {
        super(name);
    }

    public ParallelDestination(String name, int workersCoreSize, int workersMaxSize) {
        super(name, workersCoreSize, workersMaxSize);
    }

    @Override
    protected void dispatch(Set<MessageListener> messageListeners, final Message message) {
        final Thread currentThread = Thread.currentThread();
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        for (final MessageListener messageListener : messageListeners) {
            MessageRunnable runnable = new MessageRunnable(message){

                @Override
                public void run() {
                    try {
                        try {
                            ParallelDestination.this.populateThreadLocalsFromMessage(message);
                            messageListener.receive(message);
                        }
                        catch (MessageListenerException mle) {
                            _log.error("Unable to process message " + message, mle);
                            if (Thread.currentThread() != currentThread) {
                                ThreadLocalCacheManager.clearAll(Lifecycle.REQUEST);
                                CentralizedThreadLocal.clearShortLivedThreadLocals();
                            }
                        }
                    }
                    finally {
                        if (Thread.currentThread() != currentThread) {
                            ThreadLocalCacheManager.clearAll(Lifecycle.REQUEST);
                            CentralizedThreadLocal.clearShortLivedThreadLocals();
                        }
                    }
                }
            };
            threadPoolExecutor.execute(runnable);
        }
    }
}

