/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.PageLock;
import com.ecyrd.jspwiki.PageManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WeblogPlugin;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class WeblogEntryPlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger(WeblogEntryPlugin.class);
    private static final int MAX_BLOG_ENTRIES = 10000;
    public static final String PARAM_ENTRYTEXT = "entrytext";
    public static final String PARAM_BLOGNAME = "page";

    public String getNewEntryPage(WikiEngine engine, String blogName) throws ProviderException {
        SimpleDateFormat fmt = new SimpleDateFormat("ddMMyy");
        String today = fmt.format(new Date());
        int entryNum = this.findFreeEntry(engine.getPageManager(), blogName, today);
        String blogPage = WeblogPlugin.makeEntryPage(blogName, today, "" + entryNum);
        return blogPage;
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        String weblogName = (String)params.get(PARAM_BLOGNAME);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        WikiEngine engine = context.getEngine();
        StringBuffer sb = new StringBuffer();
        String entryText = (String)params.get(PARAM_ENTRYTEXT);
        if (entryText == null) {
            entryText = rb.getString("weblogentryplugin.newentry");
        }
        String url = context.getURL(WikiContext.NONE, "NewBlogEntry.jsp", "page=" + engine.encodeName(weblogName));
        sb.append("<a href=\"" + url + "\">" + entryText + "</a>");
        return sb.toString();
    }

    private int findFreeEntry(PageManager mgr, String baseName, String date) throws ProviderException {
        WikiPage page;
        PageLock lock;
        int idx;
        Collection everyone = mgr.getAllPages();
        int max = 0;
        String startString = WeblogPlugin.makeEntryPage(baseName, date, "");
        for (WikiPage p : everyone) {
            if (!p.getName().startsWith(startString)) continue;
            try {
                String probableId = p.getName().substring(startString.length());
                int id = Integer.parseInt(probableId);
                if (id <= max) continue;
                max = id;
            }
            catch (NumberFormatException e) {
                log.debug((Object)("Was not a log entry: " + p.getName()));
            }
        }
        for (idx = max + 1; idx < 10000 && (lock = mgr.getCurrentLock(page = new WikiPage(mgr.getEngine(), WeblogPlugin.makeEntryPage(baseName, date, Integer.toString(idx))))) != null; ++idx) {
        }
        return idx;
    }
}

