/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ccpp;

import com.sun.ccpp.Log;
import com.sun.ccpp.ProfileDiff;
import com.sun.ccpp.ProfileFragmentFactoryImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.ccpp.ProfileFragment;
import javax.servlet.http.HttpServletRequest;

public class HttpRequestProcessor {
    private Logger logger = Log.getLogger();
    private boolean normalize = defNormalize;
    private boolean verifyDigest = defVerifyDigest;
    private static boolean defNormalize = true;
    private static boolean defVerifyDigest = false;

    public static void setNormalize(boolean val) {
        defNormalize = val;
    }

    public static void setVerifyDigest(boolean val) {
        defVerifyDigest = val;
    }

    ProfileFragment[] process(HttpServletRequest req) {
        Vector fragments = new Vector();
        fragments.addAll(this.getRefs(req.getHeaders("x-wap-profile")));
        fragments.addAll(this.getRefs(req.getHeaders("profile")));
        HashMap digests = new HashMap();
        digests.putAll(this.getDigests(req.getHeaders("x-wap-profile")));
        digests.putAll(this.getDigests(req.getHeaders("profile")));
        Vector diffs = new Vector();
        diffs.addAll(this.getWDiffs(req.getHeaders("x-wap-profile-diff"), digests));
        diffs.addAll(this.getWDiffs(req.getHeaders("profile-diff"), digests));
        if (digests.size() != diffs.size()) {
            this.logger.info("Number of profile diff and digest headers mismatch. Profile diffs: " + diffs.size() + ". " + "Digests: " + digests.size() + ".");
        }
        fragments.addAll(diffs);
        Vector numNS = new Vector();
        numNS.addAll(this.getNumNS(req.getHeaders("opt")));
        numNS.addAll(this.getNumNS(req.getHeaders("man")));
        digests.clear();
        int i = 0;
        while (i < numNS.size()) {
            fragments.addAll(this.getRefs(req.getHeaders(numNS.elementAt(i) + "-profile")));
            digests.putAll(this.getDigests(req.getHeaders(numNS.elementAt(i) + "-profile")));
            fragments.addAll(this.getExDiffs(req, (String)numNS.elementAt(i), digests));
            ++i;
        }
        Object[] pfa = new ProfileFragment[fragments.size()];
        fragments.copyInto(pfa);
        return pfa;
    }

    private Vector getRefs(Enumeration headers) {
        Vector<ProfileFragment> refs = new Vector<ProfileFragment>();
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            StringTokenizer str = new StringTokenizer(value, "\",");
            while (str.hasMoreTokens()) {
                String token = str.nextToken();
                if (!token.startsWith("http")) continue;
                try {
                    URL url = new URL(token);
                    ProfileFragment fragment = ProfileFragmentFactoryImpl.getInstance().newProfileFragment(url);
                    refs.add(fragment);
                }
                catch (MalformedURLException e) {
                    this.logger.info("Invalid URL for profile reference. " + e.getMessage());
                }
            }
        }
        return refs;
    }

    private HashMap getDigests(Enumeration headers) {
        HashMap<Integer, String> digests = new HashMap<Integer, String>();
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            StringTokenizer str = new StringTokenizer(value, "\",");
            while (str.hasMoreTokens()) {
                String token = str.nextToken();
                if (token.startsWith("http") || token.indexOf(45) <= 0) continue;
                try {
                    Integer diffSeq = new Integer(token.substring(0, token.indexOf(45)));
                    String digest = token.substring(token.indexOf(45) + 1);
                    digests.put(diffSeq, digest);
                }
                catch (NumberFormatException e) {
                    this.logger.info("Invalid diff digest header. " + token + " " + e.getMessage());
                }
            }
        }
        return digests;
    }

    private Vector getWDiffs(Enumeration headers, HashMap diffDigests) {
        Vector<ProfileFragment> diffs = new Vector<ProfileFragment>();
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            int sep = value.indexOf(59);
            Integer diffSeq = null;
            try {
                String dsStr = value.substring(0, sep);
                dsStr = dsStr.trim();
                diffSeq = new Integer(dsStr);
            }
            catch (Exception e) {
                this.logger.info("Invalid profile diff header. " + value + " " + e.getMessage());
                continue;
            }
            String diffStr = value.substring(sep + 1);
            String digest = (String)diffDigests.get(diffSeq);
            ProfileFragment diff = this.getDiffFragment(diffStr, digest);
            if (diff == null) continue;
            diffs.add(diff);
        }
        return diffs;
    }

    private Vector getNumNS(Enumeration headers) {
        Vector<String> numNS = new Vector<String>();
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            int delim = value.indexOf("ns=");
            if (delim <= 0) continue;
            numNS.add(value.substring(delim + 3));
        }
        return numNS;
    }

    private Vector getExDiffs(HttpServletRequest req, String numNS, HashMap digests) {
        Vector<ProfileFragment> diffs = new Vector<ProfileFragment>();
        Iterator diffSeqs = digests.keySet().iterator();
        while (diffSeqs.hasNext()) {
            Integer diffSeq = (Integer)diffSeqs.next();
            String digest = (String)digests.get(diffSeq);
            ProfileFragment diff = this.getDiffFragment(req.getHeader(numNS + "-profile-diff-" + diffSeq), digest);
            if (diff == null) continue;
            diffs.add(diff);
        }
        return diffs;
    }

    private ProfileFragment getDiffFragment(String diffStr, String digest) {
        if (diffStr == null || digest == null) {
            return null;
        }
        diffStr.trim();
        while (diffStr.charAt(0) == '\"' && diffStr.charAt(diffStr.length() - 1) == '\"') {
            diffStr = diffStr.substring(1, diffStr.length() - 2);
        }
        ProfileFragment diff = ProfileFragmentFactoryImpl.getInstance().newProfileFragment(diffStr);
        if (!this.verifyDigest) {
            return diff;
        }
        String calculated = null;
        try {
            calculated = ProfileDiff.getDigest(diffStr, this.normalize);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        if (!digest.equals(calculated)) {
            this.logger.warning("Profile diff digest mismatch. Calculated digest: " + calculated + ". " + "HTTP Header digest: " + digest + ".");
            return null;
        }
        return diff;
    }
}

